<?php

namespace TdySports\Controller\Web;

use TdyCommons\Controller\BaseWebController;
use Zend\Http\PhpEnvironment\Request as PhpRequest;
use Zend\Http\PhpEnvironment\Response as PhpResponse;
use Zend\Session;
use Zend\View\Model\JsonModel;
use Zend\View\Model\ViewModel;

class LeaguesController extends BaseWebController
{

    /**
     * @return ViewModel
     */
    public function indexAction()
    {
        $view = new ViewModel();
        return $view;
    }

    /**
     * @return ViewModel
     */
    public function scriptAction()
    {
        /** @var PhpResponse $phpResponse */
        $phpResponse = $this->getResponse();
        $phpResponse->getHeaders()->addHeaderLine('Content-type', 'text/javascript');

        $view = new ViewModel();
        $view->setTerminal(true);
        $view->setTemplate('tdy-sports/leagues/scp-script.js');

        return $view;
    }

    /**
     * @return ViewModel
     */
    public function serviceAction()
    {
        /** @var PhpResponse $phpResponse */
        $phpResponse = $this->getResponse();
        $phpResponse->getHeaders()->addHeaderLine('Content-type', 'text/javascript');

        $view = new ViewModel();
        $view->setTerminal(true);
        $view->setTemplate('tdy-sports/leagues/scp-service.js');

        return $view;
    }

    /**
     * @return ViewModel
     */
    public function htmlAction()
    {
        $file = $this->params()->fromRoute('file', 'index');

        /** @var PhpResponse $phpResponse */
        $phpResponse = $this->getResponse();
        $phpResponse->getHeaders()->addHeaderLine('Content-type', 'text/plain');

        $view = new ViewModel();
        $view->setTerminal(true);
        $view->setTemplate('tdy-sports/leagues/tpl-' . $file . '.phtml');

        return $view;
    }

}
