<?php

namespace TdyPlayers\Controller;

use TdyCommons\Controller\BaseWebController;
use Zend\Crypt\Password;
use Zend\Http\PhpEnvironment\Response as PhpResponse;
use Zend\View\Model\ViewModel;
use Zend\View\Model\JsonModel;

class ProfileController extends BaseWebController
{

    public function indexAction()
    {
        return new ViewModel();
    }

    public function changePasswordAction()
    {
        $httpRequest = $this->getRequest();
        $isXhr       = $httpRequest->isXmlHttpRequest();
        $user        = $this->getUserTable()->get($this->getCurrentPlayer()->id);

        $form = new ChangePasswordForm();

        if ($httpRequest->isGet()) {
            if ($isXhr) {
                $this->getResponse()->getHeaders()->addHeaderLine('Content-type', 'text/plain');
                $view = new ViewModel();
                $view->setTerminal(true);
                $view->setVariable('form', $form);
                $view->setVariable('user', $user);
                $view->setVariable('isXhr', $isXhr);

                return $view;
            } else {
                return [
                    'isXhr' => $isXhr,
                    'form' => $form,
                    'user' => $user
                ];
            }
        } else {
            if ($httpRequest->isPost()) {
                $form->setData($httpRequest->getPost());
                if ($form->isValid()) {
                    $currentPlayer = $this->getCurrentPlayer();
                    $data        = $form->getData();

                    $bcrypt = new Password\Bcrypt();
                    $valid  = $bcrypt->verify($data['passwordOld'], $user->password);
                    if ($valid) {
                        $user->password  = $bcrypt->create($data['passwordNew1']);
                        $user->updatedBy = $currentPlayer->id;
                        $this->getUserTable()->resetPassword($user);
                        $this->flashMessenger()->setNamespace('profile')->addSuccessMessage('Your password has been changed.');
                    } else {
                        $this->flashMessenger()->setNamespace('profile')->addErrorMessage('Invalid current password.');
                    }

                    if ($isXhr) {
                        $this->getResponse()->getHeaders()->addHeaderLine('Content-type', 'text/json');
                        $view = new JsonModel();
                        $view->setTerminal(true);
                        $view->setVariable('result', true);

                        return $view;
                    } else {
                        return $this->redirect()->toRoute('profile/manage', ['action' => 'change-password']);
                    }
                } else {

                }
            }
        }
    }

    /**
     * @return ViewModel
     */
    public function htmlAction()
    {
        $file = $this->params()->fromRoute('file', 'index');

        /** @var PhpResponse $phpResponse */
        $phpResponse = $this->getResponse();
        $phpResponse->getHeaders()->addHeaderLine('Content-type', 'text/plain');

        $view = new ViewModel();
        $view->setTerminal(true);
        $view->setTemplate('tdy-players/profile/tpl-' . $file . '.phtml');

        return $view;
    }

    /**
     * @return ViewModel
     */
    public function scriptAction()
    {
        /** @var PhpResponse $phpResponse */
        $phpResponse = $this->getResponse();
        $phpResponse->getHeaders()->addHeaderLine('Content-type', 'text/javascript');
        $view = new ViewModel();
        $view->setTerminal(true);
        $view->setTemplate('tdy-players/profile/script.js');

        return $view;
    }

}
