<?php

return [
    'router'       => [
        'routes' => [
            'login'      => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/login',
                    'defaults' => [
                        'module'     => 'TdyPlayers',
                        'controller' => 'TdyPlayers\Controller\Logging',
                        'action'     => 'login'
                    ],
                ],
                'may_terminate' => true,
            ],
            'login.js'   => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/login.js',
                    'defaults' => [
                        'module'     => 'TdyPlayers',
                        'controller' => 'TdyPlayers\Controller\Logging',
                        'action'     => 'script'
                    ],
                ],
                'may_terminate' => true,
            ],
            'logout'     => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/logout',
                    'defaults' => [
                        'module'     => 'TdyPlayers',
                        'controller' => 'TdyPlayers\Controller\Logging',
                        'action'     => 'logout'
                    ],
                ],
                'may_terminate' => true,
            ],
            'signup'     => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/signup',
                    'defaults' => [
                        'module'     => 'TdyPlayers',
                        'controller' => 'TdyPlayers\Controller\Logging',
                        'action'     => 'signup'
                    ],
                ],
                'may_terminate' => true,
            ],
            'signup.js'  => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/signup.js',
                    'defaults' => [
                        'module'     => 'TdyPlayers',
                        'controller' => 'TdyPlayers\Controller\Logging',
                        'action'     => 'signupScript'
                    ],
                ],
                'may_terminate' => true,
            ],
            'toc'     => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/toc',
                    'defaults' => [
                        'module'     => 'TdyPlayers',
                        'controller' => 'TdyPlayers\Controller\Logging',
                        'action'     => 'toc'
                    ],
                ],
                'may_terminate' => true,
            ],
            'logging'    => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/logging',
                    'defaults' => [
                        'module'     => 'TdyPlayers',
                        'controller' => 'TdyPlayers\Controller\Logging',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'html' => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdyPlayers',
                                'controller' => 'TdyPlayers\Controller\Logging',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
            'players'    => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/players',
                    'defaults' => [
                        'module'     => 'TdyPlayers',
                        'controller' => 'TdyPlayers\Controller\Web\Players',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index'   => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdyPlayers',
                                'controller' => 'TdyPlayers\Controller\Web\Players',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'main.js' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/main.js',
                            'defaults' => [
                                'module'     => 'TdyPlayers',
                                'controller' => 'TdyPlayers\Controller\Web\Players',
                                'action'     => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'rest'    => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/rest[/:id][.:format]',
                            'constraints' => [
                                'id'     => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults'    => [
                                'module'     => 'TdyPlayers',
                                'controller' => 'TdyPlayers\Controller\Rest\Players',
                                'format'     => 'json',
                                'action'     => null,
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'html'    => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdyPlayers',
                                'controller' => 'TdyPlayers\Controller\Web\Players',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
            'profile'    => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/profile',
                    'defaults' => [
                        'module'     => 'TdyPlayers',
                        'controller' => 'TdyPlayers\Controller\Profile',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index'   => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdyPlayers',
                                'controller' => 'TdyPlayers\Controller\Profile',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'html'    => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdyPlayers',
                                'controller' => 'TdyPlayers\Controller\Profile',
                                'action'     => 'html'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'main.js' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/main.js',
                            'defaults' => [
                                'module'     => 'TdyPlayers',
                                'controller' => 'TdyPlayers\Controller\Profile',
                                'action'     => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
        ],
    ],
    'controllers'  => [
        'invokables' => [
            'TdyPlayers\Controller\Logging'      => 'TdyPlayers\Controller\LoggingController',
            'TdyPlayers\Controller\Profile'      => 'TdyPlayers\Controller\ProfileController',
            'TdyPlayers\Controller\Web\Players'  => 'TdyPlayers\Controller\Web\PlayersController',
            'TdyPlayers\Controller\Rest\Players' => 'TdyPlayers\Controller\Rest\PlayersController',
        ],
    ],
    'view_manager' => [
        'template_map'        => [
            'layout/layout' => __DIR__ . '/../view/layout/login.phtml',
        ],
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies'          => [
            'ViewJsonStrategy',
        ],
    ],

];
