<?php

namespace TdyGames\Controller\Rest;

use TdyGames\Model\Contest;
use TdyGames\InputFilter\Contest as ContestInputFilter;
use TdyCommons\Controller\BaseRestController;
use Zend\View\Model\JsonModel;

class ContestsController extends BaseRestController
{
    protected $identifierName = 'id';

    /**
     * @return JsonModel
     */
    public function getList()
    {
        $this->getLogger()->debug('ContestsController::getList() start.');

        $q = $this->params()->fromQuery('q', '');
        $p = (int) $this->params()->fromQuery('p', 1);
        $l = (int) $this->params()->fromQuery('l', $this->getSettingsTable()->get('items-per-page'));
        $s = $this->params()->fromQuery('s', []);
        $f = $this->params()->fromQuery('f', []);
        $x = [];

        $isPaginated = $l > 0;

        /**
        if (!isset($f['week_id'])) {
            $currentWeek = $this->getWeeksTable()->getCurrentWeek();
            $f['week_id'] = $currentWeek->id;
        }
        **/

        $resultSet = $this->getContestsTable()->setIndent(self::LOGGER_INDENT)->fetch($q, $x, $f, $s, $isPaginated);
        $resultSet->setCurrentPageNumber((int) $p);
        $resultSet->setItemCountPerPage($l);

        if ($p > 0) {
            $i = (($p - 1) * $l);
        } else {
            $i = 0;
        }

        $contests = iterator_to_array($resultSet, false);

        /**
         * @var int     $k
         * @var Contest $contest
         */
        foreach ($contests as $k => $contest) {
            $contest->setServiceLocator($this->getServiceLocator());
            $contests[$k]->row      = ++$i;
            $contests[$k]->playerId = $this->getCurrentPlayer()->id;
            $contests[$k]           = $contest->toStdClass();
        }

        $this->getLogger()->debug('ContestsController::getList() end.');

        return $this->statusOk([
            'entries'    => $contests,
            'pagination' => [
                'pageNumber' => $p,
                'pageSize'   => $l,
                'totalItems' => $resultSet->getTotalItemCount(),
                'totalPages' => $resultSet->count(),
            ],

        ]);
    }

    /**
     * @param int|string $id
     *
     * @return JsonModel
     */
    public function get($id)
    {
        $contest = $this->getContestsTable()->get($id);

        if ($contest) {
            $contest->setServiceLocator($this->getServiceLocator());
            $contest->playerId = $this->getCurrentPlayer()->id;

            return $this->statusOk([
                'entry'      => $contest->toStdClass(),
                'pagination' => [
                    'pageNumber' => 1,
                    'pageSize'   => 1,
                    'totalItems' => 1,
                    'totalPages' => 1,
                ],
            ]);
        } else {
            return $this->statusNotFound();
        }
    }

    /**
     * @param mixed $data
     *
     * @return JsonModel
     */
    public function create($data)
    {
        $this->getLogger()->debug('ContestsController::create() start.');

        switch ($data['action']) {
            case 'join':
            default:
                $contest = $this->getContestsTable()->get($data['contestId']);
                $player  = $this->getCurrentPlayer();

                $this->getContestsTable()->setIndent(self::LOGGER_INDENT)->join($contest, $player, $data['mixes']);
                break;

        };

        $this->getLogger()->debug('ContestsController::create() end.');

        return $this->statusOk([
            'entry'      => null,
            'pagination' => [
                'pageNumber' => 1,
                'pageSize'   => 1,
                'totalItems' => 1,
                'totalPages' => 1,
            ],
        ]);

    }

}
