<?php

namespace TdyGames;

use TdyGames\Model\Mixture;
use TdyGames\Model\Slot;
use Zend\Authentication\Adapter as AuthAdapter;
use Zend\Authentication\Storage;
use Zend\Db\Adapter\Adapter as DbAdapter;
use Zend\Db\ResultSet\HydratingResultSet;
use Zend\Db\TableGateway\TableGateway;
use Zend\Di\ServiceLocatorInterface;
use Zend\ModuleManager\Feature\AutoloaderProviderInterface;
use Zend\ModuleManager\Feature\ConfigProviderInterface;
use Zend\ModuleManager\Feature\ServiceProviderInterface;
use Zend\ModuleManager\Feature\ViewHelperProviderInterface;
use Zend\Session;

class Module implements AutoloaderProviderInterface, ConfigProviderInterface, ServiceProviderInterface, ViewHelperProviderInterface
{

    public function getConfig()
    {
        $general = include __DIR__ . '/config/general.php';
        $db      = include __DIR__ . '/config/db.php';

        return array_merge($general, $db);
    }

    public function getAutoloaderConfig()
    {
        return [
            'Zend\Loader\StandardAutoloader' => [
                'namespaces' => [
                    __NAMESPACE__ => __DIR__ . '/src/' . __NAMESPACE__,
                ],
            ],
        ];
    }

    public function getViewHelperConfig()
    {
        return [];
    }

    public function getServiceConfig()
    {
        return [
            'factories' => [
                'TdyGames\Table\Types'                   => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['game_types']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['game_types']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Model\Type());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Types($tableGateway, $columns);
                    $table->setLogger($logger);

                    return $table;
                },
                'TdyGames\Table\Attributes'              => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['game_attributes']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['game_attributes']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Model\Attribute());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Attributes($tableGateway, $columns);
                    $table->setLogger($logger);

                    return $table;
                },
                'TdyGames\Table\Contests'                => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['contests']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['contests']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Model\Contest());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Contests($tableGateway, $columns);
                    $table->setLogger($logger);
                    $table->setRelatedTables([
                        'contests_slots'          => $sm->get('config')['mappings']['tables']['contests_slots'],
                        'contests_slots_mixtures' => $sm->get('config')['mappings']['tables']['contests_slots_mixtures'],
                    ]);

                    return $table;
                },
                'TdyGames\Table\Contests\Slots'          => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['contests_slots']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['contests_slots']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Slot());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Slots($tableGateway, $columns);
                    $table->setLogger($logger);

                    return $table;
                },
                'TdyGames\Table\Contests\Slots\Mixtures' => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['contests_slots_mixtures']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['contests_slots_mixtures']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Mixture());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Mixtures($tableGateway, $columns);
                    $table->setLogger($logger);

                    $table->setRelatedTables([
                        'contests_slots' => $sm->get('config')['mappings']['tables']['contests_slots'],
                    ]);

                    return $table;
                },
            ],
        ];
    }

}