<?php

namespace TdyCommons\View\Model;

use Zend\Http\Response;
use Zend\View\Model\ViewModel;

/**
 * Class XlsxModel
 *
 * @package TdyCommons\View\Model
 */
class XlsxModel extends ViewModel
{

    /**
     * @var \PHPExcel
     */
    protected $excelFile;

    /**
     * @var null
     */
    protected $captureTo = null;

    /**
     * Excel2007 (XLSX) is always terminal
     *
     * @var bool
     */
    protected $terminate = true;

    /**
     * @param \PHPExcel $excelFile
     */
    public function __construct($excelFile)
    {
        $this->excelFile = $excelFile;
    }

    /**
     * @return string
     */
    public function generate()
    {
        $writer = \PHPExcel_IOFactory::createWriter($this->excelFile, 'Excel2007');

        ob_start();
        $writer->save('php://output');
        $output = ob_get_clean();

        return $output;
    }

}