<?php

namespace TdyCommons\Model;

use TdyCommons\Filter\Word\LowercaseFirst;
use Zend\Filter\FilterChain;
use Zend\Filter\Word\DashToCamelCase;
use Zend\Filter\Word\UnderscoreToCamelCase;
use Zend\ServiceManager\ServiceLocatorInterface;

/**
 * Class DropdownItem
 *
 * @package TdyCommons\Model
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class DropdownItem extends Model
{
    /**
     * The Item ID.
     *
     * @var int
     */
    public $id = 0;

    /**
     * Item slug.
     *
     * @var string
     */
    public $slug = '';

    /**
     * The name of the Item.
     *
     * @var string
     */
    public $name = '';

    /**
     * @var string
     */
    public $description = '';

    /**
     * Item value.
     *
     * @var string
     */
    public $value = '';

    /**
     * List ID.
     *
     * @var int
     */
    public $listId = 0;

    /**
     * Order.
     *
     * @var int
     */
    public $ordering = INFINITY;

    /**
     * @var ServiceLocatorInterface|null
     */
    protected $sm;

    /**
     * Item constructor.
     *
     * @param array                        $data
     * @param ServiceLocatorInterface|null $sm
     */
    public function __construct($data = null, $sm = null)
    {
        if (!empty($data) && is_array($data)) {
            $this->exchangeArray($data);
        }

        $this->sm = $sm;
    }

    /**
     * @param ServiceLocatorInterface|null $sm
     */
    public function setServiceLocator($sm)
    {
        $this->sm = $sm;
    }

    /**
     * @see Model::exchangeArray();
     *
     * @param array $data
     */
    public function exchangeArray($data)
    {
        foreach ($data as $key => $value) {
            $filter = new FilterChain();
            if (strpos($key, '-') !== false) {
                $filter->attach(new DashToCamelCase());
            } else {
                $filter->attach(new UnderscoreToCamelCase());
            }

            $filter->attach(new LowercaseFirst());
            $nKey = $filter->filter($key);

            if (!property_exists(__CLASS__, $nKey)) {
                continue;
            } else {
                if ($nKey == 'id' || $nKey == 'listId' || $nKey == 'ordinal') {
                    $this->$nKey = (int) $value;
                } else {
                    $this->$nKey = $value;
                }
            }
        }
        parent::exchangeArray($data);
    }

    /**
     * @return DropdownList|null
     */
    public function getList()
    {
        if (!is_null($this->sm)) {
            $table = $this->sm->get('TdyCommons\Table\Lists');
            $list  = $table->get($this->listId);

            return $list;
        } else {
            return null;
        }
    }

    /**
     * @see parent::toStdClass()
     *
     * @return \StdClass|void
     */
    public function toStdClass()
    {
        $list = $this->getList()->toStdClass();

        $object = parent::toStdClass();

        if (!is_null($this->sm)) {
            unset($object->listId);
            $object->list = $list;
        }

        return $object;
    }

}
