<?php

namespace TdySports\Controller\Rest;

use TdyGames\Model\Contest;
use TdyGames\Model\Mixture;
use TdyGames\Model\Slot;
use TdySports\Model\Standing;
use TdySports\InputFilter\Standing as StandingInputFilter;
use TdyCommons\Controller\BaseRestController;
use TdySports\Model\Week;
use Zend\Filter\File\RenameUpload;
use Zend\Http\PhpEnvironment\Request;
use Zend\View\Model\JsonModel;

class StandingsController extends BaseRestController
{
    protected $identifierName = 'id';

    /**
     * @return JsonModel
     */
    public function getList()
    {
        $this->getLogger()->debug('StandingsController::getList() start.');

        $q = $this->params()->fromQuery('q', '');
        $p = (int) $this->params()->fromQuery('p', 1);
        $l = (int) $this->params()->fromQuery(
            'l', $this->getSettingsTable()->get('items-per-page')
        );
        $s = $this->params()->fromQuery('s', []);
        $f = $this->params()->fromQuery('f', []);
        $x = [];

        $resultSet = $this->getStandingsTable()->setIndent(self::LOGGER_INDENT)->fetch($q, $x, $f, $s, true);
        $resultSet->setCurrentPageNumber((int) $p);
        $resultSet->setItemCountPerPage($l);

        if ($p > 0) {
            $i = (($p - 1) * $l);
        } else {
            $i = 0;
        }

        $standings = iterator_to_array($resultSet, false);

        /**
         * @var int      $k
         * @var Standing $standing
         */
        foreach ($standings as $k => $standing) {
            $standing->setServiceLocator($this->getServiceLocator());
            $standings[$k]->row = ++$i;
            $standings[$k]      = $standing->toStdClass();
        }

        $this->getLogger()->debug('StandingsController::getList() end.');

        return $this->statusOk(
            [
                'entries'    => $standings,
                'pagination' => [
                    'pageNumber' => $p,
                    'pageSize'   => $l,
                    'totalItems' => $resultSet->getTotalItemCount(),
                    'totalPages' => $resultSet->count(),
                ],

            ]
        );
    }

    /**
     * @param int|string $id
     *
     * @return JsonModel
     */
    public function get($id)
    {
        $standing = $this->getStandingsTable()->get($id);
        $standing->setServiceLocator($this->getServiceLocator());

        return $this->statusOk(
            [
                'entry'      => $standing->toStdClass(),
                'pagination' => [
                    'pageNumber' => 1,
                    'pageSize'   => 1,
                    'totalItems' => 1,
                    'totalPages' => 1,
                ],
            ]
        );
    }

    public function patchList($data)
    {

        $action = isset($data['action']) ? $data['action'] : '';

        switch ($action) {
            case 'update-standings':
                return $this->updateScores($data['info'], $data['items']);
            default:
                return $this->statusBadRequest(
                    [
                        'system'    => [
                            'id'          => 4001,
                            'description' => 'Invalid Request',
                        ],
                        'companies' => [
                            'description' => 'Action ID is missing.',
                            'details'     => '',
                        ],
                    ]
                );
        }
    }


    protected function updateScores($info, $items)
    {

        foreach ($items as $item) {
            $standing = new Standing($item);
            $this->getStandingsTable()->updateStandings($standing);
        }

        return $this->statusOk(
            [
                'entry'      => null,
                'pagination' => [
                    'pageNumber' => 1,
                    'pageSize'   => 1,
                    'totalItems' => 1,
                    'totalPages' => 1,
                ],
            ]
        );
    }

}
