<?php

return [
    'mappings' => [
        'tables' => [
            'game_types'              => [
                'name'    => 'gme_types',
                'columns' => [
                    'id'          => 'id',
                    'slug'        => 'slug',
                    'name'        => 'name',
                    'description' => 'description',
                    'ordering'    => 'ordering',
                    'is-core'     => 'is_core',
                    'is-active'   => 'is_active',
                    'created-by'  => 'created_by',
                    'created-on'  => 'created_on',
                    'updated-by'  => 'updated_by',
                    'updated-on'  => 'updated_on',
                    'deleted-by'  => 'deleted_by',
                    'deleted-on'  => 'deleted_on',
                ],
            ],
            'game_attributes'         => [
                'name'    => 'gme_attributes',
                'columns' => [
                    'id'         => 'id',
                    'key'        => 'key',
                    'name'       => 'name',
                    'value'      => 'value',
                    'ordering'   => 'ordering',
                    'is-core'    => 'is_core',
                    'is-active'  => 'is_active',
                    'created-by' => 'created_by',
                    'created-on' => 'created_on',
                    'updated-by' => 'updated_by',
                    'updated-on' => 'updated_on',
                    'deleted-by' => 'deleted_by',
                    'deleted-on' => 'deleted_on',
                ],
            ],
            'contests'                => [
                'name'    => 'gme_contests',
                'columns' => [
                    'id'             => 'id',
                    'slug'           => 'slug',
                    'name'           => 'name',
                    'description'    => 'description',
                    'sport-id'       => 'sport_id',
                    'league-id'      => 'league_id',
                    'week-id'        => 'week_id',
                    'min-players'    => 'min_players',
                    'max-players'    => 'max_players',
                    'joined-players' => 'joined_players',
                    'entrance-fee'   => 'entrance_fee',
                    'prize'          => 'prize',
                    'status'         => 'status',
                    'is-core'        => 'is_core',
                    'is-active'      => 'is_active',
                    'created-by'     => 'created_by',
                    'created-on'     => 'created_on',
                    'updated-by'     => 'updated_by',
                    'updated-on'     => 'updated_on',
                    'deleted-by'     => 'deleted_by',
                    'deleted-on'     => 'deleted_on',
                ],
            ],
            'contests_slots'          => [
                'name'    => 'gme_contests_slots',
                'columns' => [
                    'id'           => 'id',
                    'contest-id'   => 'contest_id',
                    'player-id'    => 'player_id',
                    'total-points' => 'total_points',
                    'place'        => 'place',
                    'is-core'      => 'is_core',
                    'is-active'    => 'is_active',
                    'created-by'   => 'created_by',
                    'created-on'   => 'created_on',
                    'updated-by'   => 'updated_by',
                    'updated-on'   => 'updated_on',
                    'deleted-by'   => 'deleted_by',
                    'deleted-on'   => 'deleted_on',
                ],
            ],
            'contests_slots_mixtures' => [
                'name'    => 'gme_contests_slots_mixtures',
                'columns' => [
                    'id'             => 'id',
                    'slot-id'        => 'slot_id',
                    'team-home'      => 'team_home',
                    'team-home-side' => 'team_home_side',
                    'team-away'      => 'team_away',
                    'team-away-side' => 'team_away_side',
                    'bet'            => 'bet',
                    'score-home'     => 'score_home',
                    'score-away'     => 'score_away',
                    'points'         => 'points',
                    'is-core'        => 'is_core',
                    'is-active'      => 'is_active',
                    'created-by'     => 'created_by',
                    'created-on'     => 'created_on',
                    'updated-by'     => 'updated_by',
                    'updated-on'     => 'updated_on',
                    'deleted-by'     => 'deleted_by',
                    'deleted-on'     => 'deleted_on',
                ],
            ],
        ],
        'views'  => [
            'game_types_active'              => [
                'name'    => 'gme_types_active',
                'columns' => [
                    'id'          => 'id',
                    'slug'        => 'slug',
                    'name'        => 'name',
                    'description' => 'description',
                    'ordering'    => 'ordering',
                    'is-core'     => 'is_core',
                    'is-active'   => 'is_active',
                    'created-by'  => 'created_by',
                    'created-on'  => 'created_on',
                    'updated-by'  => 'updated_by',
                    'updated-on'  => 'updated_on',
                    'deleted-by'  => 'deleted_by',
                    'deleted-on'  => 'deleted_on',
                ],
            ],
            'game_attributes_active'         => [
                'name'    => 'gme_attributes_active',
                'columns' => [
                    'id'         => 'id',
                    'key'        => 'key',
                    'name'       => 'name',
                    'value'      => 'value',
                    'ordering'   => 'ordering',
                    'is-core'    => 'is_core',
                    'is-active'  => 'is_active',
                    'created-by' => 'created_by',
                    'created-on' => 'created_on',
                    'updated-by' => 'updated_by',
                    'updated-on' => 'updated_on',
                    'deleted-by' => 'deleted_by',
                    'deleted-on' => 'deleted_on',
                ],
            ],
            'gme_contests_active'            => [
                'name'    => 'gme_contests_active',
                'columns' => [
                    'id'             => 'id',
                    'slug'           => 'slug',
                    'name'           => 'name',
                    'description'    => 'description',
                    'sport-id'       => 'sport_id',
                    'league-id'      => 'league_id',
                    'week-id'        => 'week_id',
                    'min-players'    => 'min_players',
                    'max-players'    => 'max_players',
                    'joined-players' => 'joined_players',
                    'entrance-fee'   => 'entrance_fee',
                    'prize'          => 'prize',
                    'is-core'        => 'is_core',
                    'is-active'      => 'is_active',
                    'created-by'     => 'created_by',
                    'created-on'     => 'created_on',
                    'updated-by'     => 'updated_by',
                    'updated-on'     => 'updated_on',
                    'deleted-by'     => 'deleted_by',
                    'deleted-on'     => 'deleted_on',
                ],
            ],
            'contests_slots_active'          => [
                'name'    => 'gme_contests_slots_active',
                'columns' => [
                    'id'          => 'id',
                    'username'    => 'username',
                    'last-name'   => 'last_name',
                    'first-name'  => 'first_name',
                    'middle-name' => 'middle_name',
                    'suffix'      => 'suffix',
                    'nickname'    => 'nickname',
                    'email'       => 'email',
                    'is-core'     => 'is_core',
                    'is-active'   => 'is_active',
                    'created-by'  => 'created_by',
                    'created-on'  => 'created_on',
                    'updated-by'  => 'updated_by',
                    'updated-on'  => 'updated_on',
                    'deleted-by'  => 'deleted_by',
                    'deleted-on'  => 'deleted_on',
                ],
            ],
            'contests_slots_mixtures_active' => [
                'name'    => 'gme_contests_slots_mixtures_active',
                'columns' => [
                    'id'         => 'id',
                    'contest-id' => 'contest_id',
                    'player-id'  => 'player_id',
                    'slot-id'    => 'slot_id',
                    'team-home'  => 'team_home',
                    'team-away'  => 'team_away',
                    'bet'        => 'bet',
                    'score-home' => 'score_home',
                    'score-away' => 'score_away',
                    'points'     => 'points',
                    'is-core'    => 'is_core',
                    'is-active'  => 'is_active',
                    'created-by' => 'created_by',
                    'created-on' => 'created_on',
                    'updated-by' => 'updated_by',
                    'updated-on' => 'updated_on',
                    'deleted-by' => 'deleted_by',
                    'deleted-on' => 'deleted_on',
                ],
            ],
        ],
    ],
];
