<?php

namespace TdyCommons\Table;

use Zend\Db\Adapter\Adapter;
use Zend\Db\TableGateway\TableGateway;
use Zend\Log\Logger;

/**
 * Class Table
 *
 * @package TdyCommons\Table
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Table
{
    const LOGGER_INDENT = '   ';

    /**
     * @var TableGateway
     */
    protected $tableGateway;

    /**
     * @var array
     */
    protected $columns;

    /**
     * @var Logger
     */
    protected $logger;

    /**
     * @var string
     */
    protected $indent = '';

    /**
     * @param TableGateway $tableGateway
     * @param array        $columns
     */
    function __construct(TableGateway $tableGateway, $columns = [])
    {
        $this->tableGateway = $tableGateway;
        $this->columns = $columns;
    }

    /**
     * Sets the TableGatway.
     *
     * @param TableGateway $tableGateway
     */
    public function setTableGateway($tableGateway)
    {
        $this->tableGateway = $tableGateway;
    }

    /**
     * Returns the TableGateway object.
     *
     * @return TableGateway
     */
    public function getTableGateway()
    {
        return $this->tableGateway;
    }

    /**
     * @return Logger
     */
    public function getLogger()
    {
        return $this->logger;
    }

    /**
     * @param $logger
     *
     * @return $this
     */
    public function setLogger($logger)
    {
        $this->logger = $logger;

        return $this;
    }

    /**
     * @return string
     */
    public function getIndent() {
        return $this->indent;
    }

    /**
     * @param string $indent
     *
     * @return $this
     */
    public function setIndent($indent) {
        $this->indent = $indent;

        return $this;
    }

    /**
     * @return Adapter
     */
    public function getAdapter()
    {
        return $this->getTableGateway()->getAdapter();
    }

    /**
     * Checks the driver and platform and then gets the last insert ID.
     *
     * @return int
     */
    protected function getLastInsertId()
    {
        /** @var Adapter $adapter */
        $adapter = $this->tableGateway->adapter;

        $platformName = $adapter->getPlatform()->getName();
        $driverName   = $adapter->getDriver()->getDatabasePlatformName();

        if ($driverName == 'Dblib' && $platformName == 'SQLServer') {
            $sql       = "SELECT SCOPE_IDENTITY() as id";
            $resultSet = $adapter->query($sql, Adapter::QUERY_MODE_EXECUTE);
            $row       = $resultSet->current();
            $id        = (int) $row->id;
        } else {
            $id = (int) $this->tableGateway->getLastInsertValue();
        }

        return $id;
    }

    /**
     * Checks if the array of columns with values has sort values.
     *
     * @param array $sort
     *
     * @return bool
     */
    public function isSortEmpty($sort)
    {
        $empty = true;
        if (is_array($sort) && count($sort) > 0) {
            foreach ($sort as $v) {
                if (!empty($v)) {
                    $empty = false;
                    break;
                }
            }
        }

        return $empty;
    }

}