<?php

namespace TdyCommons\Model;

use TdyCommons\Filter\Word\LowercaseFirst;
use Zend\Filter\FilterChain;
use Zend\Filter\Word\DashToCamelCase;
use Zend\Filter\Word\UnderscoreToCamelCase;

/**
 * Class BaseOption
 * @package TdyCommons\Model
 *
 * The Base Option model class. A class simpler than the Option class.
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class BaseOption extends Model
{

    /**
     * The name of the Option.
     *
     * @var string
     */
    public $name = '';

    /**
     * Option value.
     *
     * @var string
     */
    public $value = '';

    /**
     * Order.
     *
     * @var int
     */
    public $ordinal = INFINITY;

    /**
     * Option constructor.
     *
     * @param array $data
     */
    public function __construct($data = null)
    {
        if (!empty($data) && is_array($data)) {
            $this->exchangeArray($data);
        }
    }

    /**
     * @see Model::exchangeArray();
     *
     * @param array $data
     */
    public function exchangeArray($data)
    {
        foreach ($data as $key => $value) {
            $filter = new FilterChain();
            if (strpos($key, '-') !== false) {
                $filter->attach(new DashToCamelCase());
            } else {
                $filter->attach(new UnderscoreToCamelCase());
            }

            $filter->attach(new LowercaseFirst());
            $nKey = $filter->filter($key);

            if (!property_exists(__CLASS__, $nKey)) {
                continue;
            } else {
                if ($nKey == 'id' || $nKey == 'ordinal') {
                    $this->$nKey = (int) $value;
                } else {
                    $this->$nKey = $value;
                }
            }
        }
        parent::exchangeArray($data);
    }

}
