<?php

return [
    'router' => [
        'routes' => [
            'login' => [
                'type' => 'Literal',
                'options' => [
                    'route' => '/login',
                    'defaults' => [
                        'module' => 'TdyAdmins',
                        'controller' => 'TdyAdmins\Controller\Logging',
                        'action' => 'login'
                    ],
                ],
                'may_terminate' => true,
            ],
            'login.js' => [
                'type' => 'Literal',
                'options' => [
                    'route' => '/login.js',
                    'defaults' => [
                        'module' => 'TdyAdmins',
                        'controller' => 'TdyAdmins\Controller\Logging',
                        'action' => 'script'
                    ],
                ],
                'may_terminate' => true,
            ],
            'logout' => [
                'type' => 'Literal',
                'options' => [
                    'route' => '/logout',
                    'defaults' => [
                        'module' => 'TdyAdmins',
                        'controller' => 'TdyAdmins\Controller\Logging',
                        'action' => 'logout'
                    ],
                ],
                'may_terminate' => true,
            ],
            'admins' => [
                'type' => 'Literal',
                'options' => [
                    'route' => '/admins',
                    'defaults' => [
                        'module' => 'TdyAdmins',
                        'controller' => 'TdyAdmins\Controller\Web\Admins',
                        'action' => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes' => [
                    'index' => [
                        'type' => 'Literal',
                        'options' => [
                            'route' => '/',
                            'defaults' => [
                                'module' => 'TdyAdmins',
                                'controller' => 'TdyAdmins\Controller\Web\Admins',
                                'action' => 'index'
                            ],
                        ]
                    ],
                    'main.js' => [
                        'type' => 'Literal',
                        'options' => [
                            'route' => '/main.js',
                            'defaults' => [
                                'module' => 'TdyAdmins',
                                'controller' => 'TdyAdmins\Controller\Web\Admins',
                                'action' => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'rest' => [
                        'type' => 'Segment',
                        'options' => [
                            'route' => '/rest[/:id][.:format]',
                            'constraints' => [
                                'id' => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults' => [
                                'module' => 'TdyAdmins',
                                'controller' => 'TdyAdmins\Controller\Rest\Admins',
                                'format' => 'json',
                                'action' => null,
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'html' => [
                        'type' => 'Segment',
                        'options' => [
                            'route' => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults' => [
                                'module' => 'TdyAdmins',
                                'controller' => 'TdyAdmins\Controller\Web\Admins',
                                'action' => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
        ],
    ],
    'controllers' => [
        'invokables' => [
            'TdyAdmins\Controller\Logging' => 'TdyAdmins\Controller\LoggingController',
            'TdyAdmins\Controller\Web\Admins' => 'TdyAdmins\Controller\Web\AdminsController',
            'TdyAdmins\Controller\Rest\Admins' => 'TdyAdmins\Controller\Rest\AdminsController',
        ],
    ],
    'view_manager' => [
        'template_map'             => array(
            'layout/layout'          => __DIR__ . '/../view/layout/login.phtml',
        ),
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy',
        ],
    ],

];
