<?php

return [
    'navigation' => [
        'default' => [
            [
                'label' => 'Contests',
                'route'   => 'contests',
            ],
            [
                'label' => 'Leader Board',
                'uri'   => '#',
                'pages' => [
                    [
                        'label' => 'American Football',
                        'uri'   => '#',
                    ],
                ],
            ],
            [
                'label' => 'Sports',
                'uri'   => '#',
                'pages' => [
                    [
                        'label' => 'Sports',
                        'route' => 'sports',
                        'hash'  => true,
                        'icon'  => 'fa fa-fw fa-soccer-ball-o'
                    ],
                    [
                        'label' => 'Leagues',
                        'route' => 'leagues',
                        'hash'  => true,
                        'icon'  => 'fa fa-fw fa-soccer-ball-o'
                    ],
                    [
                        'label' => 'Groups',
                        'route' => 'groups',
                        'hash'  => true,
                        'icon'  => 'fa fa-fw fa-soccer-ball-o'
                    ],
                    [
                        'label' => 'Teams',
                        'route' => 'teams',
                        'hash'  => true,
                        'icon'  => 'fa fa-fw fa-soccer-ball-o'
                    ],
                    [
                        'uri'       => '#',
                        'separator' => true
                    ],
                    [
                        'label' => 'Seasons',
                        'route' => 'seasons',
                        'hash'  => true,
                        'icon'  => 'fa fa-fw fa-calendar'
                    ],
                    [
                        'label' => 'Weeks',
                        'route' => 'weeks',
                        'hash'  => true,
                        'icon'  => 'fa fa-fw fa-calendar'
                    ],
                    [
                        'label' => 'Schedules',
                        'route' => 'schedules',
                        'hash'  => true,
                        'icon'  => 'fa fa-fw fa-calendar'
                    ],
                ]
            ],
            [
                'label' => 'Users',
                'uri'   => '#',
                'pages' => [
                    [
                        'label' => 'Players',
                        'icon'  => 'fa fa-fw fa-user',
                        'route' => 'players',
                        'hash'  => true
                    ],
                    [
                        'uri'       => '#',
                        'separator' => true
                    ],
                    [
                        'label' => 'Admins',
                        'icon'  => 'fa fa-fw fa-user',
                        'route' => 'admins',
                        'hash'  => true
                    ],
                ]
            ],
            [
                'label' => 'Demo',
                'uri'   => '#',
                'pages' => [
                    [
                        'label' => 'Panel',
                        'uri'   => '#',
                        'icon'  => 'fa fa-fw fa-dashboard'
                    ],
                    [
                        'label' => 'Real Life Matches',
                        'uri'   => '#',
                        'icon'  => 'fa fa-fw fa-soccer-ball-o'
                    ],
                    [
                        'label' => 'Admins',
                        'icon'  => 'fa fa-fw fa-user',
                        'route' => 'admins',
                        'hash'  => true
                    ],
                ]
            ],
            [
                'label' => 'Settings',
                'uri'   => '#',
                'pages' => [
                    [
                        'label'  => 'Games',
                        'uri'    => '#',
                        'header' => true
                    ],
                    [
                        'label' => 'Types',
                        'icon'  => 'fa fa-fw fa-list',
                        'route' => 'games/types',
                    ],
                    [
                        'label' => 'Attributes',
                        'icon'  => 'fa fa-fw fa-list',
                        'route' => 'games/attributes',
                    ],
                    [
                        'uri'       => '#',
                        'separator' => true
                    ],
                    [
                        'label'  => 'Geography',
                        'uri'    => '#',
                        'header' => true
                    ],
                    [
                        'label' => 'Countries',
                        'icon'  => 'fa fa-fw fa-globe',
                        'uri'   => '#',
                    ],
                    [
                        'label' => 'Divisions',
                        'icon'  => 'fa fa-fw fa-globe',
                        'uri'   => '#',
                    ],
                    [
                        'label' => 'Localities',
                        'icon'  => 'fa fa-fw fa-globe',
                        'uri'   => '#',
                    ],
                    [
                        'uri'       => '#',
                        'separator' => true
                    ],
                    [
                        'label' => 'Dropdown Lists',
                        'icon'  => 'fa fa-fw fa-list',
                        'route' => 'dropdown-lists',
                        'hash'  => true
                    ],
                    [
                        'label' => 'System',
                        'icon'  => 'fa fa-fw fa-gear',
                        'uri'   => '#',
                    ],
                ]
            ],
        ],
    ],
];