/**
 * Configuration
 */
FanSportsApp.config([ '$httpProvider', '$stateProvider', '$urlRouterProvider', function ($httpProvider, $stateProvider, $urlRouterProvider) {
    $httpProvider.defaults.headers.common[ "X-Requested-With" ] = 'XMLHttpRequest';

    $stateProvider
        .state('home', {
            url        : '/',
            templateUrl: SportsFanPlayer.basePath + '/leagues/html/list'
        });

    $urlRouterProvider.otherwise("/");
} ]);


/**
 * Controller
 */
FanSportsApp.controller('LeaguesController', [ '$scope', '$rootScope', '$http', '$filter', '$modal', 'growl', 'SportsService', 'LeaguesService',
    function ($scope, $rootScope, $http, $filter, $modal, growl, SportsService, LeaguesService) {

        $scope.grid = LeaguesService.grid;

        $scope.sports = SportsService.grid;
        $scope.sports.call();

        $scope.league = { id: 0 };

        $scope.fields = {};

        $scope.searchAction = {
            search: function (keywords) {
                $scope.grid.queryString.q = keywords;
                $scope.grid.call();
                return $scope.grid.items;
            }
        };

        $scope.slugify = function () {
            $scope.fields.slug = $filter('fsaSlugify')($scope.fields.name);
        }


        /** Modal Add Start **/

        var modalAdd = $modal({
            templateUrl: SportsFanPlayer.basePath + '/leagues/html/add',
            scope      : $scope,
            show       : false
        });

        $scope.modalAddActions = {
            show: function () {
                $scope.league = { id: 0 };
                $scope.fields = {};
                modalAdd.$promise.then(modalAdd.show);
            },
            hide: function () {
                modalAdd.$promise.then(modalAdd.hide);
            }
        };

        /** Modal Add End **/


        /** Modal Edit Start **/

        var modalEdit = $modal({
            templateUrl: SportsFanPlayer.basePath + '/leagues/html/edit',
            scope      : $scope,
            show       : false
        });

        $scope.modalEditActions = {
            show: function (id) {
                $http({
                    method: 'GET',
                    url   : SportsFanPlayer.basePath + '/leagues/rest/' + id
                }).then(function success(data) {
                    $scope.fields = {};

                    $scope.league = data.data.response.data.entry;

                    $scope.fields.sport = $scope.league.sport;
                    $scope.fields.slug = $scope.league.slug;
                    $scope.fields.name = $scope.league.name;
                    $scope.fields.shortName = $scope.league.shortName;
                    $scope.fields.description = $scope.league.description;

                    modalEdit.$promise.then(modalEdit.show);
                }, function failure(data) {
                    growl.error('Unable to retrieve League data.');
                });
            },
            hide: function () {
                modalEdit.$promise.then(modalEdit.hide);
            }
        };

        /** Modal Edit End **/


        /** Modal Delete Start **/

        var modalDelete = $modal({
            templateUrl: SportsFanPlayer.basePath + '/leagues/html/delete',
            scope      : $scope,
            show       : false
        });

        $scope.modalDeleteActions = {
            show: function (id) {
                $http({
                    method: 'GET',
                    url   : SportsFanPlayer.basePath + '/leagues/rest/' + id
                }).then(function success(data) {
                    $scope.league = data.data.response.data.entry;

                    modalDelete.$promise.then(modalDelete.show);
                }, function failure(data) {
                    growl.error('Unable to retrieve League data.');
                });
            },
            hide: function () {
                modalDelete.$promise.then(modalDelete.hide);
            }
        };

        /** Modal Delete End **/



        $scope.submit = function (method) {
            var config = {};

            var notifSuccess = '';
            var notifFailure = '';

            switch (method) {
                case 'DELETE':
                    config = {
                        method: 'DELETE',
                        url   : SportsFanPlayer.basePath + '/leagues/rest' + '/' + $scope.league.id
                    };
                    notifSuccess = 'League has been deleted';
                    notifFailure = 'Failed to delete an League.';
                    break;
                case 'POST':
                case 'PUT':
                default:
                    config = {
                        method: $scope.league.id > 0 ? 'PUT' : 'POST',
                        url   : SportsFanPlayer.basePath + '/leagues/rest' + ($scope.league.id > 0 ? ('/' + $scope.league.id) : ''),
                        data  : {
                            'sport-id'   : $scope.fields.sport.id,
                            'slug'       : $scope.fields.slug,
                            'name'       : $scope.fields.name,
                            'short-name' : $scope.fields.shortName,
                            'description': $scope.fields.description
                        }
                    };
                    if ($scope.league.id > 0) {
                        notifSuccess = 'League has been updated.';
                        notifFailure = 'Failed to update an League.';
                    } else {
                        notifSuccess = 'League has been added.';
                        notifFailure = 'Failed to add an League';
                    }
            }

            $http(config).then(function success() {
                $scope.init.home();
                switch (method) {
                    case 'DELETE':
                        $scope.modalDeleteActions.hide();
                        break;
                    case 'POST':
                        $scope.modalAddActions.hide();
                        break;
                    case 'PUT':
                        $scope.modalEditActions.hide();
                        break;
                    default:
                        if ($scope.league.id > 0) {
                            $scope.modalEditActions.hide();
                        } else {
                            $scope.modalAddActions.hide();
                        }
                }
                growl.success(notifSuccess);
            }, function failure() {
                switch (method) {
                    case 'DELETE':
                        $scope.modalDeleteActions.hide();
                        break;
                    case 'POST':
                        $scope.modalAddActions.hide();
                        break;
                    case 'PUT':
                        $scope.modalEditActions.hide();
                        break;
                    default:
                        if ($scope.league.id > 0) {
                            $scope.modalEditActions.hide();
                        } else {
                            $scope.modalAddActions.hide();
                        }
                }
                growl.error(notifFailure);
            });
        };

        $scope.init = {
            'home': function () {
                $scope.grid.queryString.q = '';
                $scope.grid.queryString.f = '';
                $scope.grid.queryString.s = '';
                $scope.grid.results.totalItems = null;
                $scope.grid.results.totalPages = null;
                $scope.grid.call();
            }
        };

    }
]);