<?php

namespace TdySports\InputFilter;

use TdyCommons\InputFilter\BaseInputFilter;
use Zend\InputFilter\Factory as InputFilterFactory;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\Validator;

/**
 * Class Sport
 *
 * @package TdySports\InputFilter
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Group extends BaseInputFilter
{

    /**
     * @param ServiceLocatorInterface $sm
     * @param bool                    $isEdit
     */
    public function __construct($sm, $isEdit = false)
    {
        $this->sm = $sm;

        $factory = new InputFilterFactory();

        $this->add($factory->createInput([
            'name'     => 'id',
            'required' => false,
            'filters'  => $this->filterStrings(),
        ]));

        $this->add($factory->createInput([
            'name'       => 'sport-id',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Sport ID is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS   => 'Invalid Sport ID.',
                            Validator\Digits::INVALID      => 'Invalid Sport ID.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'league-id',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('League ID is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS   => 'Invalid League ID.',
                            Validator\Digits::INVALID      => 'Invalid League ID.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'play-datetime',
            'required'   => false,
            'filters'    => $this->filterStrings(),
        ]));

        $this->add($factory->createInput([
            'name'       => 'name',
            'required'   => false,
            'filters'    => $this->filterStrings(),
        ]));

        $this->add($factory->createInput([
            'name'     => 'description',
            'required' => false,
            'filters'  => $this->filterStrings(),
        ]));

        $this->add($factory->createInput([
            'name'       => 'team-home',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Home Team ID is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS   => 'Invalid Team ID.',
                            Validator\Digits::INVALID      => 'Invalid Team ID.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'team-away',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Away Team ID is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS   => 'Invalid Team ID.',
                            Validator\Digits::INVALID      => 'Invalid Team ID.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'     => 'venue',
            'required' => false,
            'filters'  => $this->filterStrings(),
        ]));

        $this->add($factory->createInput([
            'name'       => 'status',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Status is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS   => 'Invalid Team ID.',
                            Validator\Digits::INVALID      => 'Invalid Team ID.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'score-home',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Score for Home Team is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS   => 'Invalid score.',
                            Validator\Digits::INVALID      => 'Invalid score.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'score-away',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Score for Away Team is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS   => 'Invalid score.',
                            Validator\Digits::INVALID      => 'Invalid score.',
                        ],
                    ],
                ],
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'ending',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Ending ID is required.'),
                [
                    'name'    => '\Zend\Validator\Digits',
                    'options' => [
                        'messages' => [
                            Validator\Digits::NOT_DIGITS   => 'Invalid ending ID.',
                            Validator\Digits::INVALID      => 'Invalid ending ID.',
                        ],
                    ],
                ],
            ],
        ]));

    }

}