<?php

return [
    'mappings' => [
        'tables' => [
            'sports'    => [
                'name'    => 'spt_sports',
                'columns' => [
                    'id'          => 'id',
                    'slug'        => 'slug',
                    'name'        => 'name',
                    'description' => 'description',
                    'ordering'    => 'ordering',
                    'is-core'     => 'is_core',
                    'is-active'   => 'is_active',
                    'created-by'  => 'created_by',
                    'created-on'  => 'created_on',
                    'updated-by'  => 'updated_by',
                    'updated-on'  => 'updated_on',
                    'deleted-by'  => 'deleted_by',
                    'deleted-on'  => 'deleted_on',
                ]
            ],
            'leagues'   => [
                'name'    => 'spt_leagues',
                'columns' => [
                    'id'          => 'id',
                    'sport-id'    => 'sport_id',
                    'slug'        => 'slug',
                    'name'        => 'name',
                    'short-name'  => 'short_name',
                    'description' => 'description',
                    'ordering'    => 'ordering',
                    'is-core'     => 'is_core',
                    'is-active'   => 'is_active',
                    'created-by'  => 'created_by',
                    'created-on'  => 'created_on',
                    'updated-by'  => 'updated_by',
                    'updated-on'  => 'updated_on',
                    'deleted-by'  => 'deleted_by',
                    'deleted-on'  => 'deleted_on',
                ]
            ],
            'groups'    => [
                'name'    => 'spt_leagues_groups',
                'columns' => [
                    'id'          => 'id',
                    'sport-id'    => 'sport_id',
                    'league-id'   => 'league_id',
                    'slug'        => 'slug',
                    'name'        => 'name',
                    'short-name'  => 'short_name',
                    'description' => 'description',
                    'ordering'    => 'ordering',
                    'is-core'     => 'is_core',
                    'is-active'   => 'is_active',
                    'created-by'  => 'created_by',
                    'created-on'  => 'created_on',
                    'updated-by'  => 'updated_by',
                    'updated-on'  => 'updated_on',
                    'deleted-by'  => 'deleted_by',
                    'deleted-on'  => 'deleted_on',
                ]
            ],
            'weeks'     => [
                'name'    => 'spt_leagues_weeks',
                'columns' => [
                    'id'         => 'id',
                    'sport-id'   => 'sport_id',
                    'league-id'  => 'league_id',
                    'slug'       => 'slug',
                    'number'     => 'number',
                    'name'       => 'name',
                    'is-current' => 'is_current',
                    'is-core'    => 'is_core',
                    'is-active'  => 'is_active',
                    'created-by' => 'created_by',
                    'created-on' => 'created_on',
                    'updated-by' => 'updated_by',
                    'updated-on' => 'updated_on',
                    'deleted-by' => 'deleted_by',
                    'deleted-on' => 'deleted_on',
                ]
            ],
            'teams'     => [
                'name'    => 'spt_leagues_teams',
                'columns' => [
                    'id'             => 'id',
                    'sport-id'       => 'sport_id',
                    'league-id'      => 'league_id',
                    'group-id'       => 'group_id',
                    'slug'           => 'slug',
                    'name'           => 'name',
                    'short-name'     => 'short_name',
                    'type'           => 'type',
                    'description'    => 'description',
                    'logo-original'  => 'logo_original',
                    'logo-large'     => 'logo_large',
                    'logo-medium'    => 'logo_medium',
                    'logo-thumbnail' => 'logo_thumbnail',
                    'team-picture'   => 'team_picture',
                    'ordering'       => 'ordering',
                    'is-core'        => 'is_core',
                    'is-active'      => 'is_active',
                    'created-by'     => 'created_by',
                    'created-on'     => 'created_on',
                    'updated-by'     => 'updated_by',
                    'updated-on'     => 'updated_on',
                    'deleted-by'     => 'deleted_by',
                    'deleted-on'     => 'deleted_on',
                ]
            ],
            'schedules' => [
                'name'    => 'spt_schedules',
                'columns' => [
                    'id'            => 'id',
                    'sport-id'      => 'sport_id',
                    'league-id'     => 'league_id',
                    'week-id'       => 'week_id',
                    'play-datetime' => 'play_datetime',
                    'name'          => 'name',
                    'description'   => 'description',
                    'team-home'     => 'team_home',
                    'team-away'     => 'team_away',
                    'venue'         => 'venue',
                    'status'        => 'status',
                    'score-home'    => 'score_home',
                    'score-away'    => 'score_away',
                    'ending'        => 'ending',
                    'is-core'       => 'is_core',
                    'is-active'     => 'is_active',
                    'created-by'    => 'created_by',
                    'created-on'    => 'created_on',
                    'updated-by'    => 'updated_by',
                    'updated-on'    => 'updated_on',
                    'deleted-by'    => 'deleted_by',
                    'deleted-on'    => 'deleted_on',
                ]
            ],
            'statuses'  => [
                'name'       => 'com_dropdown_lists_items',
                'columns'    => [
                    'id'         => 'value',
                    'slug'       => 'slug',
                    'name'       => 'name',
                    'is-core'    => 'is_core',
                    'is-active'  => 'is_active',
                    'created-by' => 'created_by',
                    'created-on' => 'created_on',
                    'updated-by' => 'updated_by',
                    'updated-on' => 'updated_on',
                    'deleted-by' => 'deleted_by',
                    'deleted-on' => 'deleted_on',
                ],
                'conditions' => [
                    'list-id' => [
                        'key'   => 'list_id',
                        'value' => 1
                    ]
                ]
            ],
            'standings' => [
                'name'    => 'spt_leagues_standings',
                'columns' => [
                    'id'         => 'id',
                    'team-id'    => 'team_id',
                    'league-id'  => 'league_id',
                    'season-id'  => 'season_id',
                    'week-id'    => 'week_id',
                    'wins'       => 'wins',
                    'losses'     => 'losses',
                    'ties'       => 'ties',
                    'precentage' => 'percentage',
                    'is-core'    => 'is_core',
                    'is-active'  => 'is_active',
                    'created-by' => 'created_by',
                    'created-on' => 'created_on',
                    'updated-by' => 'updated_by',
                    'updated-on' => 'updated_on',
                    'deleted-by' => 'deleted_by',
                    'deleted-on' => 'deleted_on',
                ]
            ],
        ],
        'views'  => [
            'sports_active'  => [
                'name'    => 'spt_sports_active',
                'columns' => [
                    'id'          => 'id',
                    'slug'        => 'slug',
                    'name'        => 'name',
                    'description' => 'description',
                    'ordering'    => 'ordering',
                    'is-core'     => 'is_core ',
                    'is-active'   => 'is_active',
                    'created-by'  => 'created_by',
                    'created-on'  => 'created_on',
                    'updated-by'  => 'updated_by',
                    'updated-on'  => 'updated_on',
                    'deleted-by'  => 'deleted_by',
                    'deleted-on'  => 'deleted_on',
                ]
            ],
            'leagues_active' => [
                'name'    => 'spt_leagues_active',
                'columns' => [
                    'id'          => 'id',
                    'sport-id'    => 'sport_id',
                    'slug'        => 'slug',
                    'name'        => 'name',
                    'short-name'  => 'short_name',
                    'description' => 'description',
                    'ordering'    => 'ordering',
                    'is-core'     => 'is_core',
                    'is-active'   => 'is_active',
                    'created-by'  => 'created_by',
                    'created-on'  => 'created_on',
                    'updated-by'  => 'updated_by',
                    'updated-on'  => 'updated_on',
                    'deleted-by'  => 'deleted_by',
                    'deleted-on'  => 'deleted_on',
                ]
            ],
            'groups_active'  => [
                'name'    => 'spt_leagues_groups_active',
                'columns' => [
                    'id'          => 'id',
                    'sport-id'    => 'sport_id',
                    'league-id'   => 'league_id',
                    'slug'        => 'slug',
                    'name'        => 'name',
                    'short-name'  => 'short_name',
                    'description' => 'description',
                    'ordering'    => 'ordering',
                    'is-core'     => 'is_core',
                    'is-active'   => 'is_active',
                    'created-by'  => 'created_by',
                    'created-on'  => 'created_on',
                    'updated-by'  => 'updated_by',
                    'updated-on'  => 'updated_on',
                    'deleted-by'  => 'deleted_by',
                    'deleted-on'  => 'deleted_on',
                ]
            ],
            'teams_active'   => [
                'name'    => 'spt_leagues_teams_aactive',
                'columns' => [
                    'id'             => 'id',
                    'sport-id'       => 'sport_id',
                    'league-id'      => 'league_id',
                    'group-id'       => 'group_id',
                    'slug'           => 'slug',
                    'name'           => 'name',
                    'short-name'     => 'short_name',
                    'type'           => 'type',
                    'description'    => 'description',
                    'logo-original'  => 'logo_original',
                    'logo-large'     => 'logo_large',
                    'logo-medium'    => 'logo_medium',
                    'logo-thumbnail' => 'logo_thumbnail',
                    'team-picture'   => 'team_picture',
                    'ordering'       => 'ordering',
                    'is-core'        => 'is_core',
                    'is-active'      => 'is_active',
                    'created-by'     => 'created_by',
                    'created-on'     => 'created_on',
                    'updated-by'     => 'updated_by',
                    'updated-on'     => 'updated_on',
                    'deleted-by'     => 'deleted_by',
                    'deleted-on'     => 'deleted_on',
                ]
            ],
        ]
    ]
];
