/**
 * Configuration
 */
FanSportsApp.config([ '$httpProvider', '$stateProvider', '$urlRouterProvider', '$locationProvider', function ($httpProvider, $stateProvider, $urlRouterProvider, $locationProvider) {
    $httpProvider.defaults.headers.common[ "X-Requested-With" ] = 'XMLHttpRequest';

    $stateProvider
        .state('home', {
            url        : '/',
            templateUrl: SportsFanPlayer.basePath + '/profile/html/home'
        })
        .state('edit', {
            url        : '/edit',
            templateUrl: SportsFanPlayer.basePath + '/profile/html/edit'
        })
        .state('change-pass', {
            url        : '/change-pass',
            templateUrl: SportsFanPlayer.basePath + '/profile/html/changepass'
        });

    $urlRouterProvider.otherwise("/");

} ]);



/**
 * Controller
 */
FanSportsApp.controller('ProfileController', [ '$scope', '$rootScope', '$http', '$modal', 'growl', 'PlayersService',
    function ($scope, $rootScope, $http, $modal, growl, PlayersService) {

        $scope.grid = PlayersService.grid;

        $scope.player = { id: 0 };

        $scope.fields = {};

        $scope.searchAction = {
            search: function (keywords) {
                $scope.grid.queryString.q = keywords;
                $scope.grid.call();
                return $scope.grid.items;
            }
        };


        /** Modal Add Start **/

        var modalAdd = $modal({
            templateUrl: SportsFanPlayer.basePath + '/players/html/add',
            scope      : $scope,
            show       : false
        });

        $scope.modalAddActions = {
            show: function () {
                $scope.player = { id: 0 };
                $scope.fields = {};
                modalAdd.$promise.then(modalAdd.show);
            },
            hide: function () {
                modalAdd.$promise.then(modalAdd.hide);
            }
        };

        /** Modal Add End **/


        /** Modal End Start **/

        var modalEdit = $modal({
            templateUrl: SportsFanPlayer.basePath + '/players/html/edit',
            scope      : $scope,
            show       : false
        });

        $scope.modalEditActions = {
            show: function (id) {
                $http({
                    method: 'GET',
                    url   : SportsFanPlayer.basePath + '/players/rest/' + id
                }).then(function success(data) {
                    $scope.fields = {};

                    $scope.player = data.data.response.data.entry;

                    $scope.fields.username = $scope.player.username;
                    $scope.fields.email = $scope.player.email;
                    $scope.fields.lastName = $scope.player.lastName;
                    $scope.fields.firstName = $scope.player.firstName;
                    $scope.fields.middleName = $scope.player.middleName;
                    $scope.fields.suffix = $scope.player.suffix;
                    $scope.fields.nickname = $scope.player.nickname;

                    modalEdit.$promise.then(modalEdit.show);
                }, function failure(data) {
                    growl.error('Unable to retrieve Playeristrator data.');
                });
            },
            hide: function () {
                modalEdit.$promise.then(modalEdit.hide);
            }
        };

        /** Modal Edit End **/


        /** Modal Delete Start **/

        var modalDelete = $modal({
            templateUrl: SportsFanPlayer.basePath + '/players/html/delete',
            scope      : $scope,
            show       : false
        });

        $scope.modalDeleteActions = {
            show: function (id) {
                $http({
                    method: 'GET',
                    url   : SportsFanPlayer.basePath + '/players/rest/' + id
                }).then(function success(data) {
                    $scope.player = data.data.response.data.entry;

                    modalDelete.$promise.then(modalDelete.show);
                }, function failure(data) {
                    growl.error('Unable to retrieve Playeristrator data.');
                });
            },
            hide: function () {
                modalDelete.$promise.then(modalDelete.hide);
            }
        };

        /** Modal Delete End **/



        $scope.submit = function (method) {
            var config = {};

            var notifSuccess = '';
            var notifFailure = '';

            switch (method) {
                case 'DELETE':
                    config = {
                        method: 'DELETE',
                        url   : SportsFanPlayer.basePath + '/players/rest' + '/' + $scope.player.id
                    };
                    notifSuccess = 'Playeristrator has been deleted';
                    notifFailure = 'Failed to delete an Playeristrator.';
                    break;
                case 'POST':
                case 'PUT':
                default:
                    config = {
                        method: $scope.player.id > 0 ? 'PUT' : 'POST',
                        url   : SportsFanPlayer.basePath + '/players/rest' + ($scope.player.id > 0 ? ('/' + $scope.player.id) : ''),
                        data  : {
                            username  : $scope.fields.username,
                            password  : $scope.fields.password,
                            email     : $scope.fields.email,
                            lastName  : $scope.fields.lastName,
                            firstName : $scope.fields.firstName,
                            middleName: $scope.fields.middleName,
                            suffix    : $scope.fields.suffix,
                            nickname  : $scope.fields.nickname
                        }
                    };
                    if ($scope.player.id > 0) {
                        notifSuccess = 'Playeristrator has been updated.';
                        notifFailure = 'Failed to update an Playeristrator.';
                    } else {
                        notifSuccess = 'Playeristrator has been added.';
                        notifFailure = 'Failed to add an Playeristrator';
                    }
            }

            $http(config).then(function success() {
                $scope.init.home();
                switch (method) {
                    case 'DELETE':
                        $scope.modalDeleteActions.hide();
                        break;
                    case 'POST':
                        $scope.modalAddActions.hide();
                        break;
                    case 'PUT':
                        $scope.modalEditActions.hide();
                        break;
                    default:
                        if ($scope.player.id > 0) {
                            $scope.modalEditActions.hide();
                        } else {
                            $scope.modalAddActions.hide();
                        }
                }
                growl.success(notifSuccess);
            }, function failure() {
                switch (method) {
                    case 'DELETE':
                        $scope.modalDeleteActions.hide();
                        break;
                    case 'POST':
                        $scope.modalAddActions.hide();
                        break;
                    case 'PUT':
                        $scope.modalEditActions.hide();
                        break;
                    default:
                        if ($scope.player.id > 0) {
                            $scope.modalEditActions.hide();
                        } else {
                            $scope.modalAddActions.hide();
                        }
                }
                growl.success(notifFailure);
            });
        };

        $scope.init = {
            'home': function () {
                $scope.grid.queryString.q = '';
                $scope.grid.queryString.f = '';
                $scope.grid.queryString.s = '';
                $scope.grid.results.totalItems = null;
                $scope.grid.results.totalPages = null;
                $scope.grid.call();
            }
        };

    }
]);
