/**
 * Controller
 */
FanSportsApp.controller('SignupController', [ '$scope', '$window', '$rootScope', '$http', '$modal', 'growl',
    function ($scope, $window, $rootScope, $http, $modal, growl) {

        $scope.player = { id: 0 };

        $scope.fields = {
        	'question1': [],
        };

        $scope.sports = [
            'Football',
            'Baseball',
            'Basketball',
            'Hockey',
            'Other Sports'
        ];

        $scope.submit = function () {

            var config = {
                method: 'POST',
                url   : SportsFanPlayer.basePath + '/signup',
                data  : {
                    'username'  : $scope.fields.username,
                    'password'  : $scope.fields.password,
                    'email'     : $scope.fields.email,
                    'phone'     : $scope.fields.phone,
                    'lastName'  : $scope.fields.lastName,
                    'firstName' : $scope.fields.firstName,
                    'nickname'  : $scope.fields.nickname,
                    'birthdate' : $scope.fields.birthdate,
                    'question1' : $scope.fields.question1,
                    'question2' : $scope.fields.question2
                }
            };

            $http(config).then(function success() {
                growl.success('Successfully signed up.', {
                    ttl: 2500,
                    onclose: function() {
                        $window.location.href = SportsFanPlayer.basePath + '/';
                    }
                });
            }, function failure() {
                growl.error('Failed to sign up.');
            });
        };


    }
]);
