/**
 * Service
 */
FanSportsApp.factory('DropdownListsService', [ '$http', function ($http) {
    var Grid = {
        isLoading  : false,
        items      : [],
        queryString: {
            q: '',    // Query
            f: '',  // Filter
            s: ''   // Sort
        },
        pagination : {
            currentPage: 1,
            pageSize   : 20
        },
        results    : {
            totalItems: null,
            totalPages: null
        },
        call       : function () {
            var query = '';

            Grid.isLoading = true;

            query += 'q=' + Grid.queryString.q;
            query += Grid.queryString.f != '' ? ('&' + Grid.queryString.f) : '';
            query += Grid.queryString.s != '' ? ('&' + Grid.queryString.s) : '';
            query += Grid.pagination.pageSize > 0 ? '&l=' + Grid.pagination.pageSize : '';
            query += '&p=' + Grid.pagination.currentPage;

            $http({
                method: 'GET',
                url   : SportsFanPlayer.basePath + '/dropdown-lists/rest?' + query
            }).then(function (data) {
                Grid.items = data.data.response.data.entries;
                Grid.results = {
                    totalItems: data.data.response.data.pagination.totalItems,
                    totalPages: data.data.response.data.pagination.totalPages
                };
                Grid.isLoading = false;
            });
        },
        refresh    : function () {
            Grid.queryString = {
                q: '',
                f: '',
                s: ''
            };
            Grid.pagination = {
                currentPage: 1,
                pageSize   : 20
            };
            Grid.call();
        },
        selectPage : function () {
            Grid.call();
            return false;
        }
    };

    return {
        grid: Grid
    };
} ]);


FanSportsApp.factory('DropdownItemsService', [ '$http', function ($http) {
    var Grid = {
        listId: 0,
        isLoading  : false,
        items      : [],
        queryString: {
            q: '',  // Query
            f: '',  // Filter
            s: ''   // Sort
        },
        pagination : {
            currentPage: 1,
            pageSize   : 20
        },
        results    : {
            totalItems: null,
            totalPages: null
        },
        call       : function () {
            var query = '';

            Grid.isLoading = true;

            query += 'q=' + Grid.queryString.q;
            query += Grid.queryString.f != '' ? ('&' + Grid.queryString.f) : '';
            query += Grid.queryString.s != '' ? ('&' + Grid.queryString.s) : '';
            query += Grid.pagination.pageSize > 0 ? '&l=' + Grid.pagination.pageSize : '';
            query += '&p=' + Grid.pagination.currentPage;

            $http({
                method: 'GET',
                url   : SportsFanPlayer.basePath + '/dropdown-items/rest?' + query
            }).then(function (data) {
                Grid.items = data.data.response.data.entries;
                Grid.results = {
                    totalItems: data.data.response.data.pagination.totalItems,
                    totalPages: data.data.response.data.pagination.totalPages
                };
                Grid.isLoading = false;
            });
        },
        refresh    : function () {
            Grid.queryString = {
                q: '',
                f: '',
                s: ''
            };
            Grid.pagination = {
                currentPage: 1,
                pageSize   : 20
            };
            Grid.call();
        },
        selectPage : function () {
            Grid.call();
            return false;
        }
    };

    return {
        grid: Grid
    };
} ]);
