<?php

namespace TdyCommons\View\Helper;

use Zend\View\Helper\AbstractHelper;
use TdyCommons\Table\Settings as SettingsTable;

/**
 * Class Settings
 * @package TdyCommons\View\Helper
 *
 * A view helper class to render the value based on the Settings table.
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Settings extends AbstractHelper
{

    /**
     * @var SettingsTable
     */
    protected $table;

    /**
     * @param SettingsTable $table
     *
     * @return $this
     */
    public function setTable(SettingsTable $table)
    {
        $this->table = $table;

        return $this;
    }

    public function __invoke($key)
    {
        return $this->table->get($key, false);
    }

}
