<?php

namespace TdyCommons\View\Helper;

use TdyCommons\Table\Settings as SettingsTable;
use Zend\View\Helper\AbstractHelper;

/**
 * Class Copyright
 *
 * A view helper class that will render the copyright.
 *
 * @package TdyCommons\View\Helper
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Copyright extends AbstractHelper
{

    /**
     * The settings table.
     *
     * @var SettingsTable
     */
    protected $table;

    /**
     * @param SettingsTable $table
     *
     * @return $this
     */
    public function setTable(SettingsTable $table)
    {
        $this->table = $table;

        return $this;
    }

    /**
     * @return string
     */
    public function __invoke()
    {
        $copyright = $this->table->get('copyright', false);
        $copyright = str_replace('{YEAR}', date('Y'), $copyright);

        return $copyright;
    }

}
