/**
 * Configuration
 */
FanSportsApp.config([ '$httpProvider', '$stateProvider', '$urlRouterProvider', function ($httpProvider, $stateProvider, $urlRouterProvider) {
    $httpProvider.defaults.headers.common[ "X-Requested-With" ] = 'XMLHttpRequest';

    $stateProvider
        .state('home', {
            url        : '/',
            templateUrl: SportsFanAdmin.basePath + '/games/attributes/html/list'
        });

    $urlRouterProvider.otherwise("/");
} ]);


/**
 * Controller
 */
FanSportsApp.controller('GameAttributesController', [ '$scope', '$rootScope', '$http', '$filter', '$modal', 'growl', 'GameAttributesService',
    function ($scope, $rootScope, $http, $filter, $modal, growl, GameAttributesService) {

        $scope.grid = GameAttributesService.grid;


        $scope.fields = {};

        $scope.searchAction = {
            search: function (keywords) {
                $scope.grid.queryString.q = keywords;
                $scope.grid.call();
                return $scope.grid.items;
            }
        };


        /** Modal Add Start **/

        var modalAdd = $modal({
            templateUrl: SportsFanAdmin.basePath + '/games/attributes/html/add',
            scope      : $scope,
            show       : false
        });

        $scope.modalAddActions = {
            show: function () {
                $scope.attribute = { id: 0 };
                $scope.fields = {};
                modalAdd.$promise.then(modalAdd.show);
            },
            hide: function () {
                modalAdd.$promise.then(modalAdd.hide);
            }
        };

        /** Modal Add End **/


        /** Modal End Start **/

        var modalEdit = $modal({
            templateUrl: SportsFanAdmin.basePath + '/games/attributes/html/edit',
            scope      : $scope,
            show       : false
        });

        $scope.modalEditActions = {
            show: function (id) {
                $http({
                    method: 'GET',
                    url   : SportsFanAdmin.basePath + '/games/attributes/rest/' + id
                }).then(function success(data) {
                    $scope.fields = {};

                    $scope.attribute = data.data.response.data.entry;

                    $scope.fields.key = $scope.attribute.key;
                    $scope.fields.name = $scope.attribute.name;
                    $scope.fields.value = $scope.attribute.value;

                    modalEdit.$promise.then(modalEdit.show);
                }, function failure(data) {
                    growl.error('Unable to retrieve Sport data.');
                });
            },
            hide: function () {
                modalEdit.$promise.then(modalEdit.hide);
            }
        };

        /** Modal Edit End **/


        /** Modal Delete Start **/

        var modalDelete = $modal({
            templateUrl: SportsFanAdmin.basePath + '/games/attributes/html/delete',
            scope      : $scope,
            show       : false
        });

        $scope.modalDeleteActions = {
            show: function (id) {
                $http({
                    method: 'GET',
                    url   : SportsFanAdmin.basePath + '/games/attributes/rest/' + id
                }).then(function success(data) {
                    $scope.attribute = data.data.response.data.entry;

                    modalDelete.$promise.then(modalDelete.show);
                }, function failure(data) {
                    growl.error('Unable to retrieve Game Attribute data.');
                });
            },
            hide: function () {
                modalDelete.$promise.then(modalDelete.hide);
            }
        };

        /** Modal Delete End **/



        $scope.submit = function (method) {
            var config = {};

            var notifSuccess = '';
            var notifFailure = '';

            switch (method) {
                case 'DELETE':
                    config = {
                        method: 'DELETE',
                        url   : SportsFanAdmin.basePath + '/games/attributes/rest' + '/' + $scope.attribute.id
                    };
                    notifSuccess = 'Sport has been deleted';
                    notifFailure = 'Failed to delete an Sport.';
                    break;
                case 'POST':
                case 'PUT':
                default:
                    config = {
                        method: $scope.attribute.id > 0 ? 'PUT' : 'POST',
                        url   : SportsFanAdmin.basePath + '/games/attributes/rest' + ($scope.attribute.id > 0 ? ('/' + $scope.attribute.id) : ''),
                        data  : {
                            key  : $scope.fields.key,
                            name : $scope.fields.name,
                            value: $scope.fields.value
                        }
                    };
                    if ($scope.attribute.id > 0) {
                        notifSuccess = 'Game Attribute has been updated.';
                        notifFailure = 'Failed to update an Game Attribute.';
                    } else {
                        notifSuccess = 'Game Attribute has been added.';
                        notifFailure = 'Failed to add an Game Attribute';
                    }
            }

            $http(config).then(function success() {
                $scope.init.home();
                switch (method) {
                    case 'DELETE':
                        $scope.modalDeleteActions.hide();
                        break;
                    case 'POST':
                        $scope.modalAddActions.hide();
                        break;
                    case 'PUT':
                        $scope.modalEditActions.hide();
                        break;
                    default:
                        if ($scope.attribute.id > 0) {
                            $scope.modalEditActions.hide();
                        } else {
                            $scope.modalAddActions.hide();
                        }
                }
                growl.success(notifSuccess);
            }, function failure() {
                switch (method) {
                    case 'DELETE':
                        $scope.modalDeleteActions.hide();
                        break;
                    case 'POST':
                        $scope.modalAddActions.hide();
                        break;
                    case 'PUT':
                        $scope.modalEditActions.hide();
                        break;
                    default:
                        if ($scope.attribute.id > 0) {
                            $scope.modalEditActions.hide();
                        } else {
                            $scope.modalAddActions.hide();
                        }
                }
                growl.success(notifFailure);
            });
        };

        $scope.init = {
            'home': function () {
                $scope.grid.queryString.q = '';
                $scope.grid.queryString.f = '';
                $scope.grid.queryString.s = '';
                $scope.grid.results.totalItems = null;
                $scope.grid.results.totalPages = null;
                $scope.grid.call();
            }
        };

    }
]);