<?php

namespace TdyAdmins\Controller;

use AevCommons\Controller\BaseController;
use TdyAdmins\Form\ChangePassword as ChangePasswordForm;
use TdyCommons\Controller\BaseWebController;
use Zend\Crypt\Password;
use Zend\Mail\Message;
use Zend\View\Model\ViewModel;
use Zend\View\Model\JsonModel;

class ProfileController extends BaseWebController
{

    public function indexAction()
    {
        $httpRequest = $this->getRequest();
        $isXhr       = $httpRequest->isXmlHttpRequest();
        $user        = $this->getUserTable()->get($this->getCurrentAdmin()->id);

        if ($isXhr) {
            $this->getResponse()->getHeaders()->addHeaderLine('Content-type', 'text/plain');
            $view = new ViewModel();
            $view->setTerminal(true);
            $view->setVariable('user', $user);
            $view->setVariable('isXhr', $isXhr);

            return $view;
        } else {
            return [
                'user' => $user,
                'isXhr' => $isXhr,
            ];
        }
    }

    public function mainAction()
    {
        $httpRequest = $this->getRequest();
        $isXhr       = $httpRequest->isXmlHttpRequest();
        $user        = $this->getUserTable()->get($this->getCurrentAdmin()->id);

        if ($isXhr) {
            $this->getResponse()->getHeaders()->addHeaderLine('Content-type', 'text/plain');
            $view = new ViewModel();
            $view->setTerminal(true);
            $view->setVariable('user', $user);
            $view->setVariable('isXhr', $isXhr);

            return $view;
        } else {
            return [
                'user' => $user,
                'isXhr' => $isXhr,
            ];
        }
    }

    public function changePasswordAction()
    {
        $httpRequest = $this->getRequest();
        $isXhr       = $httpRequest->isXmlHttpRequest();
        $user        = $this->getUserTable()->get($this->getCurrentAdmin()->id);

        $form = new ChangePasswordForm();

        if ($httpRequest->isGet()) {
            if ($isXhr) {
                $this->getResponse()->getHeaders()->addHeaderLine('Content-type', 'text/plain');
                $view = new ViewModel();
                $view->setTerminal(true);
                $view->setVariable('form', $form);
                $view->setVariable('user', $user);
                $view->setVariable('isXhr', $isXhr);

                return $view;
            } else {
                return [
                    'isXhr' => $isXhr,
                    'form' => $form,
                    'user' => $user
                ];
            }
        } else {
            if ($httpRequest->isPost()) {
                $form->setData($httpRequest->getPost());
                if ($form->isValid()) {
                    $currentAdmin = $this->getCurrentAdmin();
                    $data        = $form->getData();

                    $bcrypt = new Password\Bcrypt();
                    $valid  = $bcrypt->verify($data['passwordOld'], $user->password);
                    if ($valid) {
                        $user->password  = $bcrypt->create($data['passwordNew1']);
                        $user->updatedBy = $currentAdmin->id;
                        $this->getUserTable()->resetPassword($user);
                        $this->flashMessenger()->setNamespace('profile')->addSuccessMessage('Your password has been changed.');
                    } else {
                        $this->flashMessenger()->setNamespace('profile')->addErrorMessage('Invalid current password.');
                    }

                    if ($isXhr) {
                        $this->getResponse()->getHeaders()->addHeaderLine('Content-type', 'text/json');
                        $view = new JsonModel();
                        $view->setTerminal(true);
                        $view->setVariable('result', true);

                        return $view;
                    } else {
                        return $this->redirect()->toRoute('profile/manage', ['action' => 'change-password']);
                    }
                } else {

                }
            }
        }
    }

    public function jsAction()
    {
        $this->getResponse()->getHeaders()->addHeaderLine('Content-type', 'text/javascript');
        $view = new ViewModel();
        $view->setTerminal(true);
        $view->setTemplate('aev-users/profile/script.js');

        return $view;
    }

}
