<?php

namespace TdySports\Model;

use TdyCommons\Filter\Word\LowercaseFirst;
use TdyCommons\Model\Model;
use TdySports\Table\Groups;
use TdySports\Table\Leagues;
use TdySports\Table\Sports;
use Zend\Filter\FilterChain;
use Zend\Filter\Word\DashToCamelCase;
use Zend\Filter\Word\UnderscoreToCamelCase;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\ServiceManager\ServiceManager;

/**
 * Class Team
 *
 * @package TdySports\Model
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Team extends Model
{

    /**
     * The unique ID for Sport.
     *
     * @var int
     */
    public $id = 0;

    /**
     * @var int
     */
    public $sportId = 0;

    /**
     * @var int
     */
    public $leagueId = 0;

    /**
     * @var int
     */
    public $groupId = 0;

    /**
     * @var string
     */
    public $slug = '';

    /**
     * @var string
     */
    public $name = '';

    /**
     * @var string
     */
    public $shortName = '';

    /**
     * @var string
     */
    public $description = '';

    /**
     * @var string
     */
    public $logoOriginal = '';

    /**
     * @var string
     */
    public $logoLarge = '';

    /**
     * @var string
     */
    public $logoMedium = '';

    /**
     * @var string
     */
    public $logoThumbnail = '';

    /**
     * @var string
     */
    public $teamPicture = '';

    /**
     * @var int
     */
    public $ordering = INFINITY;

    /**
     * @var null|ServiceManager|ServiceLocatorInterface
     */
    protected $sm;

    /**
     * @param null $data
     * @param null $sm
     */
    public function __construct($data = null, $sm = null)
    {
        if (!empty($data) && is_array($data)) {
            $this->exchangeArray($data);
        }

        $this->sm = $sm;
    }

    /**
     * @param null|ServiceManager|ServiceLocatorInterface $sm
     */
    public function setServiceLocator($sm)
    {
        $this->sm = $sm;
    }

    /**
     * @see Model::exchangeArray()
     *
     * @param array $data
     */
    public function exchangeArray($data)
    {
        parent::exchangeArray($data);

        foreach ($data as $key => $value) {
            $filter = new FilterChain();
            if (strpos($key, '-') !== false) {
                $filter->attach(new DashToCamelCase());
            } else {
                $filter->attach(new UnderscoreToCamelCase());
            }

            $filter->attach(new LowercaseFirst());
            $nKey = $filter->filter($key);

            if (!property_exists(__CLASS__, $nKey)) {
                continue;
            } else {
                $inArray = in_array($nKey, ['id', 'sportId', 'leagueId', 'groupId', 'ordering']);
                if ($inArray) {
                    $this->$nKey = (int) $value;
                } else {
                    $this->$nKey = $value;
                }
            }
        }
    }


    /**
     * @return null|Sport
     */
    public function getSport()
    {
        if (is_null($this->sm)) {
            return null;
        }

        /**
         * @var Sports $table
         * @var Sport  $sport
         */
        $table = $this->sm->get('TdySports\Table\Sports');
        $sport = $table->get($this->sportId);

        return $sport;
    }

    /**
     * @return null|League
     */
    public function getLeague()
    {
        if (is_null($this->sm)) {
            return null;
        }

        /**
         * @var Leagues $table
         * @var League  $sport
         */
        $table = $this->sm->get('TdySports\Table\Leagues');
        $sport = $table->get($this->leagueId);

        return $sport;
    }

    /**
     * @return null|Group
     */
    public function getGroup()
    {
        if (is_null($this->sm)) {
            return null;
        }

        /**
         * @var Groups $table
         * @var Group  $group
         */
        $table = $this->sm->get('TdySports\Table\Groups');
        $group = $table->get($this->groupId);

        return $group;
    }

    /**
     * @return \StdClass
     */
    public function toStdClass()
    {
        $object = parent::toStdClass();

        if (!is_null($this->sm)) {
            unset($object->sportId);

            $sport         = $this->getSport();
            $object->sport = $sport->toStdClass();

            unset($object->leagueId);

            $league         = $this->getLeague();
            $object->league = $league->toStdClass();

            unset($object->groupId);

            $group         = $this->getGroup();
            $object->group = $group->toStdClass();
        }

        return $object;
    }

}
