/**
 * Configuration
 */
FanSportsApp.config([ '$httpProvider', '$stateProvider', '$urlRouterProvider', function ($httpProvider, $stateProvider, $urlRouterProvider) {
    $httpProvider.defaults.headers.common[ "X-Requested-With" ] = 'XMLHttpRequest';

    $stateProvider
        .state('home', {
            url        : '/',
            templateUrl: SportsFanPlayer.basePath + '/dropdown-lists/html/list'
        })
        .state('items', {
            url        : '/:id/items',
            templateUrl: SportsFanPlayer.basePath + '/dropdown-lists/html/item'
        });

    $urlRouterProvider.otherwise("/");
} ]);


/**
 * Controller
 */
FanSportsApp.controller('DropdownListsController', [ '$scope', '$rootScope', '$http', '$filter', '$modal', 'growl', 'DropdownListsService',
    function ($scope, $rootScope, $http, $filter, $modal, growl, DropdownListService) {

        $scope.ddlGrid = DropdownListService.grid;

        $scope.list = {
            id: 0,
            name: null
        };

        $scope.fields = {};

        $scope.searchAction = {
            search: function (keywords) {
                $scope.grid.queryString.q = keywords;
                $scope.grid.call();
                return $scope.grid.items;
            }
        };

        $scope.slugify = function () {
            $scope.fields.slug = $filter('fsaSlugify')($scope.fields.name);
        };

        /** Modal Add Start **/

        var modalAdd = $modal({
            templateUrl: SportsFanPlayer.basePath + '/dropdown-list/html/add',
            scope      : $scope,
            show       : false
        });

        $scope.modalAddActions = {
            show: function () {
                $scope.list = {
                    id: 0,
                    name: null
                };
                $scope.fields = {};
                modalAdd.$promise.then(modalAdd.show);
            },
            hide: function () {
                modalAdd.$promise.then(modalAdd.hide);
            }
        };

        /** Modal Add End **/


        /** Modal End Start **/

        var modalEdit = $modal({
            templateUrl: SportsFanPlayer.basePath + '/dropdown-lists/html/edit',
            scope      : $scope,
            show       : false
        });

        $scope.modalEditActions = {
            show: function (id) {
                $http({
                    method: 'GET',
                    url   : SportsFanPlayer.basePath + '/dropdown-lists/rest/' + id
                }).then(function success(data) {
                    $scope.fields = {};

                    $scope.sport = data.data.response.data.entry;

                    $scope.fields.slug = $scope.sport.slug;
                    $scope.fields.name = $scope.sport.name;
                    $scope.fields.description = $scope.sport.description;

                    modalEdit.$promise.then(modalEdit.show);
                }, function failure(data) {
                    growl.error('Unable to retrieve Sport data.');
                });
            },
            hide: function () {
                modalEdit.$promise.then(modalEdit.hide);
            }
        };

        /** Modal Edit End **/


        /** Modal Delete Start **/

        var modalDelete = $modal({
            templateUrl: SportsFanPlayer.basePath + '/sports/html/delete',
            scope      : $scope,
            show       : false
        });

        $scope.modalDeleteActions = {
            show: function (id) {
                $http({
                    method: 'GET',
                    url   : SportsFanPlayer.basePath + '/sports/rest/' + id
                }).then(function success(data) {
                    $scope.sport = data.data.response.data.entry;

                    modalDelete.$promise.then(modalDelete.show);
                }, function failure(data) {
                    growl.error('Unable to retrieve Sport data.');
                });
            },
            hide: function () {
                modalDelete.$promise.then(modalDelete.hide);
            }
        };

        /** Modal Delete End **/



        $scope.submit = function (method) {
            var config = {};

            var notifSuccess = '';
            var notifFailure = '';

            switch (method) {
                case 'DELETE':
                    config = {
                        method: 'DELETE',
                        url   : SportsFanPlayer.basePath + '/sports/rest' + '/' + $scope.sport.id
                    };
                    notifSuccess = 'Sport has been deleted';
                    notifFailure = 'Failed to delete an Sport.';
                    break;
                case 'POST':
                case 'PUT':
                default:
                    config = {
                        method: $scope.sport.id > 0 ? 'PUT' : 'POST',
                        url   : SportsFanPlayer.basePath + '/sports/rest' + ($scope.sport.id > 0 ? ('/' + $scope.sport.id) : ''),
                        data  : {
                            slug       : $scope.fields.slug,
                            name       : $scope.fields.name,
                            description: $scope.fields.description
                        }
                    };
                    if ($scope.sport.id > 0) {
                        notifSuccess = 'Sport has been updated.';
                        notifFailure = 'Failed to update an Sport.';
                    } else {
                        notifSuccess = 'Sport has been added.';
                        notifFailure = 'Failed to add an Sport';
                    }
            }

            $http(config).then(function success() {
                $scope.init.home();
                switch (method) {
                    case 'DELETE':
                        $scope.modalDeleteActions.hide();
                        break;
                    case 'POST':
                        $scope.modalAddActions.hide();
                        break;
                    case 'PUT':
                        $scope.modalEditActions.hide();
                        break;
                    default:
                        if ($scope.sport.id > 0) {
                            $scope.modalEditActions.hide();
                        } else {
                            $scope.modalAddActions.hide();
                        }
                }
                growl.success(notifSuccess);
            }, function failure() {
                switch (method) {
                    case 'DELETE':
                        $scope.modalDeleteActions.hide();
                        break;
                    case 'POST':
                        $scope.modalAddActions.hide();
                        break;
                    case 'PUT':
                        $scope.modalEditActions.hide();
                        break;
                    default:
                        if ($scope.sport.id > 0) {
                            $scope.modalEditActions.hide();
                        } else {
                            $scope.modalAddActions.hide();
                        }
                }
                growl.success(notifFailure);
            });
        };

        $scope.init = {
            'home': function () {
                $scope.ddlGrid.queryString.q = '';
                $scope.ddlGrid.queryString.f = '';
                $scope.ddlGrid.queryString.s = '';
                $scope.ddlGrid.pagination.pageSize = 0;
                $scope.ddlGrid.results.totalItems = null;
                $scope.ddlGrid.results.totalPages = null;
                $scope.ddlGrid.call();
            }
        };

    }
]);