<?php

namespace TdyCommons\View\Helper;

use Zend\Mvc\Router\RouteMatch;
use Zend\View\Helper\AbstractHelper;

/**
 * Class Action
 *
 * @package TdyCommons\View\Helper
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class Action extends AbstractHelper
{

    /**
     * @var RouteMatch
     */
    protected $routeMatch;

    /**
     * @param $routeMatch
     *
     * @return $this
     */
    public function setRouteMatch($routeMatch)
    {
        $this->routeMatch = $routeMatch;

        return $this;
    }

    /**
     * @param bool $toLowerCase
     *
     * @return string
     */
    public function __invoke($toLowerCase = true)
    {
        if ($this->routeMatch) {
            $controller = $this->routeMatch->getParam('action', '');
            if ($toLowerCase) {
                $controller = strtolower($controller);
            }

            return $controller;
        } else {
            return '';
        }
    }

}
