<?php

namespace TdyCommons\InputFilter;

use Zend\InputFilter\Factory as InputFilterFactory;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\Validator;

/**
 * Class Selection
 *
 * @package TdyCommons\InputFilter
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class DropdownList extends BaseInputFilter
{


    /**
     * @param ServiceLocatorInterface|null $sm
     */
    public function __construct($sm = null)
    {
        $this->sm = $sm;

        $factory = new InputFilterFactory();

        $this->add($factory->createInput([
            'name'     => 'id',
            'required' => false,
        ]));

        $this->add($factory->createInput([
            'name'       => 'slug',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Dropdown List slug or short name is required.')
            ],
        ]));

        $this->add($factory->createInput([
            'name'       => 'name',
            'required'   => true,
            'filters'    => $this->filterStrings(),
            'validators' => [
                $this->validateNotEmpty('Dropdown List must have a name.')
            ],
        ]));

        $this->add($factory->createInput([
            'name'     => 'description',
            'required' => false,
            'filters'  => $this->filterStrings(),
        ]));

    }

}