<?php

namespace TdyCommons\InputFilter;

use Zend\InputFilter\InputFilter;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\Validator;

/**
 * Class BaseInputFilter
 * @package TdyCommons\InputFilter
 *
 * @author  James Lloyd Atwil <james@nadows.com>
 */
class BaseInputFilter extends InputFilter
{

    /**
     * @var ServiceLocatorInterface|null
     */
    protected $sm;

    /**
     * @param ServiceLocatorInterface|null $sm
     */
    public function __construct($sm = null)
    {
        $this->sm = $sm;
    }

    /**
     * Filter the string. Strip the HTML tags, then trim the whitespaces.
     *
     * @return array
     */
    protected function filterStrings()
    {
        return [
            ['name' => 'StripTags'],
            ['name' => 'StringTrim'],
        ];
    }

    /**
     * @param $message
     *
     * @return array
     */
    protected function validateNotEmpty($message)
    {
        return [
            'name'    => '\Zend\Validator\NotEmpty',
            'options' => [
                'encoding' => 'UTF-8',
                'messages' => [
                    Validator\NotEmpty::IS_EMPTY => $message
                ],
            ]
        ];
    }

}