<?php

namespace TdySports;

use Zend\Authentication\Adapter as AuthAdapter;
use Zend\Authentication\Storage;
use Zend\Db\Adapter\Adapter as DbAdapter;
use Zend\Db\ResultSet\HydratingResultSet;
use Zend\Db\TableGateway\TableGateway;
use Zend\Di\ServiceLocatorInterface;
use Zend\ModuleManager\Feature\AutoloaderProviderInterface;
use Zend\ModuleManager\Feature\ConfigProviderInterface;
use Zend\ModuleManager\Feature\ServiceProviderInterface;
use Zend\ModuleManager\Feature\ViewHelperProviderInterface;
use Zend\Session;

class Module implements AutoloaderProviderInterface, ConfigProviderInterface, ServiceProviderInterface, ViewHelperProviderInterface
{

    public function getConfig()
    {
        $general = include __DIR__ . '/config/general.php';
        $db      = include __DIR__ . '/config/db.php';

        return array_merge($general, $db);
    }

    public function getAutoloaderConfig()
    {
        return [
            'Zend\Loader\StandardAutoloader' => [
                'namespaces' => [
                    __NAMESPACE__ => __DIR__ . '/src/' . __NAMESPACE__,
                ],
            ],
        ];
    }

    public function getViewHelperConfig()
    {
        return [];
    }

    public function getServiceConfig()
    {
        return [
            'factories' => [
                'TdySports\Table\Sports'    => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['sports']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['sports']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Model\Sport());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Sports($tableGateway, $columns);
                    $table->setLogger($logger);

                    return $table;
                },
                'TdySports\Table\Leagues'   => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['leagues']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['leagues']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Model\League());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Leagues($tableGateway, $columns);
                    $table->setLogger($logger);

                    return $table;
                },
                'TdySports\Table\Groups'    => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['groups']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['groups']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Model\Group());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Groups($tableGateway, $columns);
                    $table->setLogger($logger);

                    return $table;
                },
                'TdySports\Table\Seasons'   => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['seasons']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['seasons']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Model\Season());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Seasons($tableGateway, $columns);
                    $table->setLogger($logger);

                    return $table;
                },
                'TdySports\Table\Weeks'     => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['weeks']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['weeks']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Model\Week());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Weeks($tableGateway, $columns);
                    $table->setLogger($logger);

                    return $table;
                },
                'TdySports\Table\Teams'     => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['teams']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['teams']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Model\Team());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Teams($tableGateway, $columns);
                    $table->setLogger($logger);

                    return $table;
                },
                'TdySports\Table\Schedules' => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['schedules']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['schedules']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Model\Schedule());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Schedules($tableGateway, $columns);
                    $table->setLogger($logger);

                    return $table;
                },
                'TdySports\Table\Statuses'  => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter  = $sm->get('db-01');
                    $tableName  = $sm->get('config')['mappings']['tables']['statuses']['name'];
                    $columns    = $sm->get('config')['mappings']['tables']['statuses']['columns'];
                    $conditions = $sm->get('config')['mappings']['tables']['statuses']['conditions'];
                    $logger     = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Model\Status());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Statuses($tableGateway, $columns, $conditions);
                    $table->setLogger($logger);

                    return $table;
                },
                'TdySports\Table\Standings' => function ($sm) {
                    /**
                     * @var ServiceLocatorInterface $sm
                     * @var DbAdapter               $dbAdapter
                     */
                    $dbAdapter = $sm->get('db-01');
                    $tableName = $sm->get('config')['mappings']['tables']['standings']['name'];
                    $columns   = $sm->get('config')['mappings']['tables']['standings']['columns'];
                    $logger    = $sm->get('Logger');

                    $resultSetProto = new HydratingResultSet();
                    $resultSetProto->setObjectPrototype(new Model\Standing());
                    $tableGateway = new TableGateway($tableName, $dbAdapter, null, $resultSetProto);
                    $table        = new Table\Standings($tableGateway, $columns);
                    $table->setLogger($logger);

                    return $table;
                },
            ],
        ];
    }

}