<?php

return [
    'router'       => [
        'routes' => [
            'games'    => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/games',
                    'defaults' => [
                        'module'     => 'TdySports',
                        'controller' => 'TdySports\Controller\Web\Sports',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'types'      => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/types',
                            'defaults' => [
                                'module'     => 'TdyGames',
                                'controller' => 'TdyGames\Controller\Web\Types',
                                'action'     => 'index'
                            ],
                        ],
                        'may_terminate' => true,
                        'child_routes'  => [
                            'index'      => [
                                'type'    => 'Literal',
                                'options' => [
                                    'route'    => '/',
                                    'defaults' => [
                                        'module'     => 'TdyGames',
                                        'controller' => 'TdyGames\Controller\Web\Types',
                                        'action'     => 'index'
                                    ],
                                ]
                            ],
                            'main.js'    => [
                                'type'          => 'Literal',
                                'options'       => [
                                    'route'    => '/main.js',
                                    'defaults' => [
                                        'module'     => 'TdyGames',
                                        'controller' => 'TdyGames\Controller\Web\Types',
                                        'action'     => 'script'
                                    ],
                                ],
                                'may_terminate' => true,
                            ],
                            'service.js' => [
                                'type'          => 'Literal',
                                'options'       => [
                                    'route'    => '/service.js',
                                    'defaults' => [
                                        'module'     => 'TdyGames',
                                        'controller' => 'TdyGames\Controller\Web\Types',
                                        'action'     => 'service'
                                    ],
                                ],
                                'may_terminate' => true,
                            ],
                            'rest'       => [
                                'type'          => 'Segment',
                                'options'       => [
                                    'route'       => '/rest[/:id][.:format]',
                                    'constraints' => [
                                        'id'     => '[0-9]+',
                                        'format' => 'json|xml|xls|xlsx|csv'
                                    ],
                                    'defaults'    => [
                                        'module'     => 'TdyGames',
                                        'controller' => 'TdyGames\Controller\Rest\Types',
                                        'format'     => 'json',
                                        'action'     => null,
                                    ],
                                ],
                                'may_terminate' => true,
                            ],
                            'html'       => [
                                'type'          => 'Segment',
                                'options'       => [
                                    'route'       => '/html[/:file]',
                                    'constraints' => [
                                        'file' => '[a-z][a-z0-9_-]+',
                                    ],
                                    'defaults'    => [
                                        'module'     => 'TdyGames',
                                        'controller' => 'TdyGames\Controller\Web\Types',
                                        'action'     => 'html',
                                    ],
                                ],
                                'may_terminate' => true,
                            ],
                        ],
                    ],
                    'attributes' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/attributes',
                            'defaults' => [
                                'module'     => 'TdyGames',
                                'controller' => 'TdyGames\Controller\Web\Attributes',
                                'action'     => 'index'
                            ],
                        ],
                        'may_terminate' => true,
                        'child_routes'  => [
                            'index'      => [
                                'type'    => 'Literal',
                                'options' => [
                                    'route'    => '/',
                                    'defaults' => [
                                        'module'     => 'TdyGames',
                                        'controller' => 'TdyGames\Controller\Web\Attributes',
                                        'action'     => 'index'
                                    ],
                                ]
                            ],
                            'main.js'    => [
                                'type'          => 'Literal',
                                'options'       => [
                                    'route'    => '/main.js',
                                    'defaults' => [
                                        'module'     => 'TdyGames',
                                        'controller' => 'TdyGames\Controller\Web\Attributes',
                                        'action'     => 'script'
                                    ],
                                ],
                                'may_terminate' => true,
                            ],
                            'service.js' => [
                                'type'          => 'Literal',
                                'options'       => [
                                    'route'    => '/service.js',
                                    'defaults' => [
                                        'module'     => 'TdyGames',
                                        'controller' => 'TdyGames\Controller\Web\Attributes',
                                        'action'     => 'service'
                                    ],
                                ],
                                'may_terminate' => true,
                            ],
                            'rest'       => [
                                'type'          => 'Segment',
                                'options'       => [
                                    'route'       => '/rest[/:id][.:format]',
                                    'constraints' => [
                                        'id'     => '[0-9]+',
                                        'format' => 'json|xml|xls|xlsx|csv'
                                    ],
                                    'defaults'    => [
                                        'module'     => 'TdyGames',
                                        'controller' => 'TdyGames\Controller\Rest\Attributes',
                                        'format'     => 'json',
                                        'action'     => null,
                                    ],
                                ],
                                'may_terminate' => true,
                            ],
                            'html'       => [
                                'type'          => 'Segment',
                                'options'       => [
                                    'route'       => '/html[/:file]',
                                    'constraints' => [
                                        'file' => '[a-z][a-z0-9_-]+',
                                    ],
                                    'defaults'    => [
                                        'module'     => 'TdyGames',
                                        'controller' => 'TdyGames\Controller\Web\Attributes',
                                        'action'     => 'html',
                                    ],
                                ],
                                'may_terminate' => true,
                            ],
                        ],
                    ],
                ],
            ],
            'contests' => [
                'type'          => 'Literal',
                'options'       => [
                    'route'    => '/contests',
                    'defaults' => [
                        'module'     => 'TdyGames',
                        'controller' => 'TdyGames\Controller\Web\Contests',
                        'action'     => 'index'
                    ],
                ],
                'may_terminate' => true,
                'child_routes'  => [
                    'index'      => [
                        'type'    => 'Literal',
                        'options' => [
                            'route'    => '/',
                            'defaults' => [
                                'module'     => 'TdyGames',
                                'controller' => 'TdyGames\Controller\Web\Contests',
                                'action'     => 'index'
                            ],
                        ]
                    ],
                    'main.js'    => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/main.js',
                            'defaults' => [
                                'module'     => 'TdyGames',
                                'controller' => 'TdyGames\Controller\Web\Contests',
                                'action'     => 'script'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'service.js' => [
                        'type'          => 'Literal',
                        'options'       => [
                            'route'    => '/service.js',
                            'defaults' => [
                                'module'     => 'TdyGames',
                                'controller' => 'TdyGames\Controller\Web\Contests',
                                'action'     => 'service'
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                    'rest'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/rest[/:id][.:format]',
                            'constraints' => [
                                'id'     => '[0-9]+',
                                'format' => 'json|xml|xls|xlsx|csv'
                            ],
                            'defaults'    => [
                                'module'     => 'TdyGames',
                                'controller' => 'TdyGames\Controller\Rest\Contests',
                                'format'     => 'json',
                                'action'     => null,
                            ],
                        ],
                        'may_terminate' => true,
                        'child_routes'  => [
                            'slots'   => [
                                'type'          => 'Segment',
                                'options'       => [
                                    'route'       => '/slots[/:st][.:format]',
                                    'constraints' => [
                                        'id'     => '[0-9]+',
                                        'format' => 'json|xml|xls|xlsx|csv'
                                    ],
                                    'defaults'    => [
                                        'module'     => 'TdyGames',
                                        'controller' => 'TdyGames\Controller\Rest\Contests\Slots',
                                        'format'     => 'json',
                                        'action'     => null,
                                    ],
                                ],
                                'may_terminate' => true,
                                'child_routes'  => [
                                    'mixtures' => [
                                        'type'          => 'Segment',
                                        'options'       => [
                                            'route'       => '/mixtures[/:mx][.:format]',
                                            'constraints' => [
                                                'id'     => '[0-9]+',
                                                'format' => 'json|xml|xls|xlsx|csv'
                                            ],
                                            'defaults'    => [
                                                'module'     => 'TdyGames',
                                                'controller' => 'TdyGames\Controller\Rest\Contests\Slots\Mixtures',
                                                'format'     => 'json',
                                                'action'     => null,
                                            ],
                                        ],
                                        'may_terminate' => true,
                                    ],
                                ],
                            ],
                            'players' => [
                                'type'          => 'Segment',
                                'options'       => [
                                    'route'       => '/players[/:pl][.:format]',
                                    'constraints' => [
                                        'id'     => '[0-9]+',
                                        'format' => 'json|xml|xls|xlsx|csv'
                                    ],
                                    'defaults'    => [
                                        'module'     => 'TdyGames',
                                        'controller' => 'TdyGames\Controller\Rest\Contests\Players',
                                        'format'     => 'json',
                                        'action'     => null,
                                    ],
                                ],
                                'may_terminate' => true,
                                'child_routes'  => [
                                    'mixtures' => [
                                        'type'          => 'Segment',
                                        'options'       => [
                                            'route'       => '/mixtures[/:mx][.:format]',
                                            'constraints' => [
                                                'id'     => '[0-9]+',
                                                'format' => 'json|xml|xls|xlsx|csv'
                                            ],
                                            'defaults'    => [
                                                'module'     => 'TdyGames',
                                                'controller' => 'TdyGames\Controller\Rest\Contests\Players\Mixtures',
                                                'format'     => 'json',
                                                'action'     => null,
                                            ],
                                        ],
                                        'may_terminate' => true,
                                    ]
                                ]
                            ]
                        ]
                    ],
                    'html'       => [
                        'type'          => 'Segment',
                        'options'       => [
                            'route'       => '/html[/:file]',
                            'constraints' => [
                                'file' => '[a-z][a-z0-9_-]+',
                            ],
                            'defaults'    => [
                                'module'     => 'TdyGames',
                                'controller' => 'TdyGames\Controller\Web\Contests',
                                'action'     => 'html',
                            ],
                        ],
                        'may_terminate' => true,
                    ],
                ],
            ],
        ],
    ],
    'controllers'  => [
        'invokables' => [
            'TdyGames\Controller\Web\Types'                      => 'TdyGames\Controller\Web\TypesController',
            'TdyGames\Controller\Rest\Types'                     => 'TdyGames\Controller\Rest\TypesController',
            'TdyGames\Controller\Web\Attributes'                 => 'TdyGames\Controller\Web\AttributesController',
            'TdyGames\Controller\Rest\Attributes'                => 'TdyGames\Controller\Rest\AttributesController',
            'TdyGames\Controller\Web\Contests'                   => 'TdyGames\Controller\Web\ContestsController',
            'TdyGames\Controller\Rest\Contests'                  => 'TdyGames\Controller\Rest\ContestsController',
            'TdyGames\Controller\Rest\Contests\Players'          => 'TdyGames\Controller\Rest\Contests\PlayersController',
            'TdyGames\Controller\Rest\Contests\Players\Mixtures' => 'TdyGames\Controller\Rest\Contests\Players\MixturesController',
            'TdyGames\Controller\Rest\Contests\Slots'            => 'TdyGames\Controller\Rest\Contests\SlotsController',
            'TdyGames\Controller\Rest\Contests\Slots\Mixtures'   => 'TdyGames\Controller\Rest\Contests\Slots\MixturesController',
        ],
    ],
    'view_manager' => [
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies'          => [
            'ViewJsonStrategy',
        ],
    ],

];
