<?php

namespace TdyCommons\View\Renderer;

use TdyCommons\View\Model\PdfModel;
use Zend\View\Exception;
use Zend\View\Model\ModelInterface as Model;
use Zend\View\Renderer\RendererInterface as Renderer;
use Zend\View\Resolver\ResolverInterface as Resolver;

/**
 * Class PdfRenderer
 *
 * Excel 2008 (XLSX) renderer
 *
 * @package TdyCommons\View\Renderer
 */
class PdfRenderer implements Renderer
{
    /**
     * @var Resolver
     */
    protected $resolver;

    /**
     * @return $this|mixed
     */
    public function getEngine()
    {
        return $this;
    }

    /**
     * @param Resolver $resolver
     *
     * @return void
     */
    public function setResolver(Resolver $resolver)
    {
        $this->resolver = $resolver;
    }

    /**
     * @param string|Model $model
     * @param null         $values
     *
     * @return string|void
     */
    public function render($model, $values = null)
    {
        if ($model instanceof Model && $model instanceof PdfModel) {
            return $model->generate();
        }

        // Both $model and $values are populated
        throw new Exception\DomainException(sprintf(
            '%s: Do not know how to handle operation when both $nameOrModel and $values are populated',
            __METHOD__
        ));
    }
}