<?php

namespace TdyCommons\View\Model;

use Zend\Http\Response;
use Zend\View\Model\ViewModel;

/**
 * Class PdfModel
 *
 * @package TdyCommons\View\Model
 */
class PdfModel extends ViewModel
{

    /**
     * @var \mPDF
     */
    protected $pdfFile;

    /**
     * @var null
     */
    protected $captureTo = null;

    /**
     * PDF is always terminal
     *
     * @var bool
     */
    protected $terminate = true;

    /**
     * @param \mPDF $pdfFile
     */
    public function __construct($pdfFile)
    {
        $this->pdfFile = $pdfFile;
    }

    /**
     * @return string
     */
    public function generate()
    {
        return $this->pdfFile->Output('', 'S');
    }

}