<?php

namespace TdyCommons\View\Factory;

use TdyCommons\View\Renderer\XlsxRenderer;
use TdyCommons\View\Strategy\XlsxStrategy;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

/**
 * Class XlsxStrategyFactory
 *
 * @package TdyCommons\View\Factory
 */
class XlsxStrategyFactory implements FactoryInterface
{
    /**
     * Create and return the XML view strategy
     *
     * Retrieves the XMLRenderer service from the service locator, and
     * injects it into the constructor for the XML strategy.
     *
     * It then attaches the strategy to the View service, at a priority of 100.
     *
     * @param  ServiceLocatorInterface $serviceLocator
     *
     * @return XlsxStrategy
     */
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        /** @var XlsxRenderer $xlsxRenderer */
        $xlsxRenderer = $serviceLocator->get('ViewXlsxRenderer');
        $xlsxStrategy = new XlsxStrategy($xlsxRenderer);

        return $xlsxStrategy;
    }
}