<?php

namespace TdyCommons\View\Factory;

use TdyCommons\View\Renderer\PdfRenderer;
use TdyCommons\View\Strategy\PdfStrategy;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

/**
 * Class PdfStrategyFactory
 *
 * @package TdyCommons\View\Factory
 */
class PdfStrategyFactory implements FactoryInterface
{
    /**
     * Create and return the XML view strategy
     *
     * Retrieves the XMLRenderer service from the service locator, and
     * injects it into the constructor for the XML strategy.
     *
     * It then attaches the strategy to the View service, at a priority of 100.
     *
     * @param  ServiceLocatorInterface $serviceLocator
     *
     * @return PdfStrategy
     */
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        /** @var PdfRenderer $xlsxRenderer */
        $xlsxRenderer = $serviceLocator->get('ViewPdfRenderer');
        $xlsxStrategy = new PdfStrategy($xlsxRenderer);

        return $xlsxStrategy;
    }
}